package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.omics.model.primitives.{
  UpdateTime,
  CreationTime,
  StoreDescription,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class UpdateVariantStoreResponse(
    id: ResourceId,
    reference: zio.aws.omics.model.ReferenceItem,
    status: zio.aws.omics.model.StoreStatus,
    name: String,
    description: StoreDescription,
    creationTime: CreationTime,
    updateTime: UpdateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.UpdateVariantStoreResponse = {
    import UpdateVariantStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.UpdateVariantStoreResponse
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .reference(reference.buildAwsValue())
      .status(status.unwrap)
      .name(name: java.lang.String)
      .description(StoreDescription.unwrap(description): java.lang.String)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .updateTime(UpdateTime.unwrap(updateTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.UpdateVariantStoreResponse.ReadOnly =
    zio.aws.omics.model.UpdateVariantStoreResponse.wrap(buildAwsValue())
}
object UpdateVariantStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.UpdateVariantStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.UpdateVariantStoreResponse =
      zio.aws.omics.model.UpdateVariantStoreResponse(
        id,
        reference.asEditable,
        status,
        name,
        description,
        creationTime,
        updateTime
      )
    def id: ResourceId
    def reference: zio.aws.omics.model.ReferenceItem.ReadOnly
    def status: zio.aws.omics.model.StoreStatus
    def name: String
    def description: StoreDescription
    def creationTime: CreationTime
    def updateTime: UpdateTime
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getReference
        : ZIO[Any, Nothing, zio.aws.omics.model.ReferenceItem.ReadOnly] =
      ZIO.succeed(reference)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.StoreStatus] =
      ZIO.succeed(status)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getDescription: ZIO[Any, Nothing, StoreDescription] =
      ZIO.succeed(description)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getUpdateTime: ZIO[Any, Nothing, UpdateTime] = ZIO.succeed(updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.UpdateVariantStoreResponse
  ) extends zio.aws.omics.model.UpdateVariantStoreResponse.ReadOnly {
    override val id: ResourceId =
      zio.aws.omics.model.primitives.ResourceId(impl.id())
    override val reference: zio.aws.omics.model.ReferenceItem.ReadOnly =
      zio.aws.omics.model.ReferenceItem.wrap(impl.reference())
    override val status: zio.aws.omics.model.StoreStatus =
      zio.aws.omics.model.StoreStatus.wrap(impl.status())
    override val name: String = impl.name(): String
    override val description: StoreDescription =
      zio.aws.omics.model.primitives.StoreDescription(impl.description())
    override val creationTime: CreationTime =
      zio.aws.omics.model.primitives.CreationTime(impl.creationTime())
    override val updateTime: UpdateTime =
      zio.aws.omics.model.primitives.UpdateTime(impl.updateTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.UpdateVariantStoreResponse
  ): zio.aws.omics.model.UpdateVariantStoreResponse.ReadOnly = new Wrapper(impl)
}
