package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.omics.model.primitives.{
  WorkflowDescription,
  WorkflowName,
  WorkflowId
}
import scala.jdk.CollectionConverters._
final case class UpdateWorkflowRequest(
    id: WorkflowId,
    name: Optional[WorkflowName] = Optional.Absent,
    description: Optional[WorkflowDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest = {
    import UpdateWorkflowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest
      .builder()
      .id(WorkflowId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => WorkflowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          WorkflowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.UpdateWorkflowRequest.ReadOnly =
    zio.aws.omics.model.UpdateWorkflowRequest.wrap(buildAwsValue())
}
object UpdateWorkflowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.UpdateWorkflowRequest =
      zio.aws.omics.model.UpdateWorkflowRequest(
        id,
        name.map(value => value),
        description.map(value => value)
      )
    def id: WorkflowId
    def name: Optional[WorkflowName]
    def description: Optional[WorkflowDescription]
    def getId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, WorkflowName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, WorkflowDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest
  ) extends zio.aws.omics.model.UpdateWorkflowRequest.ReadOnly {
    override val id: WorkflowId =
      zio.aws.omics.model.primitives.WorkflowId(impl.id())
    override val name: Optional[WorkflowName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.WorkflowName(value))
    override val description: Optional[WorkflowDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.omics.model.primitives.WorkflowDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest
  ): zio.aws.omics.model.UpdateWorkflowRequest.ReadOnly = new Wrapper(impl)
}
