package zio.aws.omics.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.{
  UploadReadSetPartRequestPartNumberInteger,
  UploadId,
  SequenceStoreId
}
import scala.jdk.CollectionConverters._
final case class UploadReadSetPartRequest(
    sequenceStoreId: SequenceStoreId,
    uploadId: UploadId,
    partSource: zio.aws.omics.model.ReadSetPartSource,
    partNumber: UploadReadSetPartRequestPartNumberInteger
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.UploadReadSetPartRequest = {
    import UploadReadSetPartRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.UploadReadSetPartRequest
      .builder()
      .sequenceStoreId(
        SequenceStoreId.unwrap(sequenceStoreId): java.lang.String
      )
      .uploadId(UploadId.unwrap(uploadId): java.lang.String)
      .partSource(partSource.unwrap)
      .partNumber(
        UploadReadSetPartRequestPartNumberInteger.unwrap(partNumber): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.UploadReadSetPartRequest.ReadOnly =
    zio.aws.omics.model.UploadReadSetPartRequest.wrap(buildAwsValue())
}
object UploadReadSetPartRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.UploadReadSetPartRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.UploadReadSetPartRequest =
      zio.aws.omics.model.UploadReadSetPartRequest(
        sequenceStoreId,
        uploadId,
        partSource,
        partNumber
      )
    def sequenceStoreId: SequenceStoreId
    def uploadId: UploadId
    def partSource: zio.aws.omics.model.ReadSetPartSource
    def partNumber: UploadReadSetPartRequestPartNumberInteger
    def getSequenceStoreId: ZIO[Any, Nothing, SequenceStoreId] =
      ZIO.succeed(sequenceStoreId)
    def getUploadId: ZIO[Any, Nothing, UploadId] = ZIO.succeed(uploadId)
    def getPartSource
        : ZIO[Any, Nothing, zio.aws.omics.model.ReadSetPartSource] =
      ZIO.succeed(partSource)
    def getPartNumber
        : ZIO[Any, Nothing, UploadReadSetPartRequestPartNumberInteger] =
      ZIO.succeed(partNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.UploadReadSetPartRequest
  ) extends zio.aws.omics.model.UploadReadSetPartRequest.ReadOnly {
    override val sequenceStoreId: SequenceStoreId =
      zio.aws.omics.model.primitives.SequenceStoreId(impl.sequenceStoreId())
    override val uploadId: UploadId =
      zio.aws.omics.model.primitives.UploadId(impl.uploadId())
    override val partSource: zio.aws.omics.model.ReadSetPartSource =
      zio.aws.omics.model.ReadSetPartSource.wrap(impl.partSource())
    override val partNumber: UploadReadSetPartRequestPartNumberInteger =
      zio.aws.omics.model.primitives
        .UploadReadSetPartRequestPartNumberInteger(impl.partNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.UploadReadSetPartRequest
  ): zio.aws.omics.model.UploadReadSetPartRequest.ReadOnly = new Wrapper(impl)
}
