package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.omics.model.primitives.S3Uri
import scala.jdk.CollectionConverters._
final case class VariantImportItemSource(source: S3Uri) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.VariantImportItemSource = {
    import VariantImportItemSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.VariantImportItemSource
      .builder()
      .source(S3Uri.unwrap(source): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.VariantImportItemSource.ReadOnly =
    zio.aws.omics.model.VariantImportItemSource.wrap(buildAwsValue())
}
object VariantImportItemSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.VariantImportItemSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.VariantImportItemSource =
      zio.aws.omics.model.VariantImportItemSource(source)
    def source: S3Uri
    def getSource: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.VariantImportItemSource
  ) extends zio.aws.omics.model.VariantImportItemSource.ReadOnly {
    override val source: S3Uri =
      zio.aws.omics.model.primitives.S3Uri(impl.source())
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.VariantImportItemSource
  ): zio.aws.omics.model.VariantImportItemSource.ReadOnly = new Wrapper(impl)
}
