package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  CreationTime,
  UpdateTime,
  AnnotationFieldMapKeyString,
  AnnotationFieldMapValueString,
  CompletionTime,
  Arn,
  RunLeftNormalization
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class VariantImportJobItem(
    id: String,
    destinationName: String,
    roleArn: Arn,
    status: zio.aws.omics.model.JobStatus,
    creationTime: CreationTime,
    updateTime: UpdateTime,
    completionTime: Optional[CompletionTime] = Optional.Absent,
    runLeftNormalization: Optional[RunLeftNormalization] = Optional.Absent,
    annotationFields: Optional[
      Map[AnnotationFieldMapKeyString, AnnotationFieldMapValueString]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.VariantImportJobItem = {
    import VariantImportJobItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.VariantImportJobItem
      .builder()
      .id(id: java.lang.String)
      .destinationName(destinationName: java.lang.String)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .status(status.unwrap)
      .creationTime(CreationTime.unwrap(creationTime): Instant)
      .updateTime(UpdateTime.unwrap(updateTime): Instant)
      .optionallyWith(
        completionTime.map(value => CompletionTime.unwrap(value): Instant)
      )(_.completionTime)
      .optionallyWith(
        runLeftNormalization.map(value =>
          RunLeftNormalization.unwrap(value): java.lang.Boolean
        )
      )(_.runLeftNormalization)
      .optionallyWith(
        annotationFields.map(value =>
          value
            .map({ case (key, value) =>
              (AnnotationFieldMapKeyString.unwrap(
                key
              ): java.lang.String) -> (AnnotationFieldMapValueString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.annotationFields)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.VariantImportJobItem.ReadOnly =
    zio.aws.omics.model.VariantImportJobItem.wrap(buildAwsValue())
}
object VariantImportJobItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.VariantImportJobItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.VariantImportJobItem =
      zio.aws.omics.model.VariantImportJobItem(
        id,
        destinationName,
        roleArn,
        status,
        creationTime,
        updateTime,
        completionTime.map(value => value),
        runLeftNormalization.map(value => value),
        annotationFields.map(value => value)
      )
    def id: String
    def destinationName: String
    def roleArn: Arn
    def status: zio.aws.omics.model.JobStatus
    def creationTime: CreationTime
    def updateTime: UpdateTime
    def completionTime: Optional[CompletionTime]
    def runLeftNormalization: Optional[RunLeftNormalization]
    def annotationFields: Optional[
      Map[AnnotationFieldMapKeyString, AnnotationFieldMapValueString]
    ]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getDestinationName: ZIO[Any, Nothing, String] =
      ZIO.succeed(destinationName)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getStatus: ZIO[Any, Nothing, zio.aws.omics.model.JobStatus] =
      ZIO.succeed(status)
    def getCreationTime: ZIO[Any, Nothing, CreationTime] =
      ZIO.succeed(creationTime)
    def getUpdateTime: ZIO[Any, Nothing, UpdateTime] = ZIO.succeed(updateTime)
    def getCompletionTime: ZIO[Any, AwsError, CompletionTime] =
      AwsError.unwrapOptionField("completionTime", completionTime)
    def getRunLeftNormalization: ZIO[Any, AwsError, RunLeftNormalization] =
      AwsError.unwrapOptionField("runLeftNormalization", runLeftNormalization)
    def getAnnotationFields: ZIO[Any, AwsError, Map[
      AnnotationFieldMapKeyString,
      AnnotationFieldMapValueString
    ]] = AwsError.unwrapOptionField("annotationFields", annotationFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.VariantImportJobItem
  ) extends zio.aws.omics.model.VariantImportJobItem.ReadOnly {
    override val id: String = impl.id(): String
    override val destinationName: String = impl.destinationName(): String
    override val roleArn: Arn =
      zio.aws.omics.model.primitives.Arn(impl.roleArn())
    override val status: zio.aws.omics.model.JobStatus =
      zio.aws.omics.model.JobStatus.wrap(impl.status())
    override val creationTime: CreationTime =
      zio.aws.omics.model.primitives.CreationTime(impl.creationTime())
    override val updateTime: UpdateTime =
      zio.aws.omics.model.primitives.UpdateTime(impl.updateTime())
    override val completionTime: Optional[CompletionTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionTime())
        .map(value => zio.aws.omics.model.primitives.CompletionTime(value))
    override val runLeftNormalization: Optional[RunLeftNormalization] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runLeftNormalization())
        .map(value =>
          zio.aws.omics.model.primitives.RunLeftNormalization(value)
        )
    override val annotationFields: Optional[
      Map[AnnotationFieldMapKeyString, AnnotationFieldMapValueString]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.annotationFields())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.omics.model.primitives.AnnotationFieldMapKeyString(
              key
            ) -> zio.aws.omics.model.primitives
              .AnnotationFieldMapValueString(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.VariantImportJobItem
  ): zio.aws.omics.model.VariantImportJobItem.ReadOnly = new Wrapper(impl)
}
