package zio.aws.omics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VcfOptions(
    ignoreQualField: Optional[Boolean] = Optional.Absent,
    ignoreFilterField: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.VcfOptions = {
    import VcfOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.VcfOptions
      .builder()
      .optionallyWith(ignoreQualField.map(value => value: java.lang.Boolean))(
        _.ignoreQualField
      )
      .optionallyWith(ignoreFilterField.map(value => value: java.lang.Boolean))(
        _.ignoreFilterField
      )
      .build()
  }
  def asReadOnly: zio.aws.omics.model.VcfOptions.ReadOnly =
    zio.aws.omics.model.VcfOptions.wrap(buildAwsValue())
}
object VcfOptions {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.omics.model.VcfOptions] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.VcfOptions =
      zio.aws.omics.model.VcfOptions(
        ignoreQualField.map(value => value),
        ignoreFilterField.map(value => value)
      )
    def ignoreQualField: Optional[Boolean]
    def ignoreFilterField: Optional[Boolean]
    def getIgnoreQualField: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ignoreQualField", ignoreQualField)
    def getIgnoreFilterField: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ignoreFilterField", ignoreFilterField)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.VcfOptions
  ) extends zio.aws.omics.model.VcfOptions.ReadOnly {
    override val ignoreQualField: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ignoreQualField())
      .map(value => value: Boolean)
    override val ignoreFilterField: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ignoreFilterField())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.VcfOptions
  ): zio.aws.omics.model.VcfOptions.ReadOnly = new Wrapper(impl)
}
