package zio.aws.omics.model
import scala.jdk.CollectionConverters._
sealed trait WorkflowEngine {
  def unwrap: software.amazon.awssdk.services.omics.model.WorkflowEngine
}
object WorkflowEngine {
  def wrap(
      value: software.amazon.awssdk.services.omics.model.WorkflowEngine
  ): zio.aws.omics.model.WorkflowEngine = value match {
    case software.amazon.awssdk.services.omics.model.WorkflowEngine.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.omics.model.WorkflowEngine.WDL =>
      val r = WDL
      r
    case software.amazon.awssdk.services.omics.model.WorkflowEngine.NEXTFLOW =>
      val r = NEXTFLOW
      r
  }
  case object unknownToSdkVersion extends zio.aws.omics.model.WorkflowEngine {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.WorkflowEngine =
      software.amazon.awssdk.services.omics.model.WorkflowEngine.UNKNOWN_TO_SDK_VERSION
  }
  case object WDL extends zio.aws.omics.model.WorkflowEngine {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.WorkflowEngine =
      software.amazon.awssdk.services.omics.model.WorkflowEngine.WDL
  }
  case object NEXTFLOW extends zio.aws.omics.model.WorkflowEngine {
    override def unwrap
        : software.amazon.awssdk.services.omics.model.WorkflowEngine =
      software.amazon.awssdk.services.omics.model.WorkflowEngine.NEXTFLOW
  }
}
