package zio.aws.omics.model
import zio.aws.omics.model.primitives.{
  WorkflowArn,
  WorkflowMetadataKey,
  WorkflowId,
  WorkflowMetadataValue,
  WorkflowTimestamp,
  WorkflowDigest,
  WorkflowName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class WorkflowListItem(
    arn: Optional[WorkflowArn] = Optional.Absent,
    id: Optional[WorkflowId] = Optional.Absent,
    name: Optional[WorkflowName] = Optional.Absent,
    status: Optional[zio.aws.omics.model.WorkflowStatus] = Optional.Absent,
    `type`: Optional[zio.aws.omics.model.WorkflowType] = Optional.Absent,
    digest: Optional[WorkflowDigest] = Optional.Absent,
    creationTime: Optional[WorkflowTimestamp] = Optional.Absent,
    metadata: Optional[Map[WorkflowMetadataKey, WorkflowMetadataValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.omics.model.WorkflowListItem = {
    import WorkflowListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.omics.model.WorkflowListItem
      .builder()
      .optionallyWith(
        arn.map(value => WorkflowArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => WorkflowId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => WorkflowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        digest.map(value => WorkflowDigest.unwrap(value): java.lang.String)
      )(_.digest)
      .optionallyWith(
        creationTime.map(value => WorkflowTimestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (WorkflowMetadataKey
                .unwrap(key): java.lang.String) -> (WorkflowMetadataValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .build()
  }
  def asReadOnly: zio.aws.omics.model.WorkflowListItem.ReadOnly =
    zio.aws.omics.model.WorkflowListItem.wrap(buildAwsValue())
}
object WorkflowListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.omics.model.WorkflowListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.omics.model.WorkflowListItem =
      zio.aws.omics.model.WorkflowListItem(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        status.map(value => value),
        `type`.map(value => value),
        digest.map(value => value),
        creationTime.map(value => value),
        metadata.map(value => value)
      )
    def arn: Optional[WorkflowArn]
    def id: Optional[WorkflowId]
    def name: Optional[WorkflowName]
    def status: Optional[zio.aws.omics.model.WorkflowStatus]
    def `type`: Optional[zio.aws.omics.model.WorkflowType]
    def digest: Optional[WorkflowDigest]
    def creationTime: Optional[WorkflowTimestamp]
    def metadata: Optional[Map[WorkflowMetadataKey, WorkflowMetadataValue]]
    def getArn: ZIO[Any, AwsError, WorkflowArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, WorkflowId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, WorkflowName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.omics.model.WorkflowStatus] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, zio.aws.omics.model.WorkflowType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDigest: ZIO[Any, AwsError, WorkflowDigest] =
      AwsError.unwrapOptionField("digest", digest)
    def getCreationTime: ZIO[Any, AwsError, WorkflowTimestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getMetadata
        : ZIO[Any, AwsError, Map[WorkflowMetadataKey, WorkflowMetadataValue]] =
      AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.omics.model.WorkflowListItem
  ) extends zio.aws.omics.model.WorkflowListItem.ReadOnly {
    override val arn: Optional[WorkflowArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.omics.model.primitives.WorkflowArn(value))
    override val id: Optional[WorkflowId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.omics.model.primitives.WorkflowId(value))
    override val name: Optional[WorkflowName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.omics.model.primitives.WorkflowName(value))
    override val status: Optional[zio.aws.omics.model.WorkflowStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.omics.model.WorkflowStatus.wrap(value))
    override val `type`: Optional[zio.aws.omics.model.WorkflowType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.omics.model.WorkflowType.wrap(value))
    override val digest: Optional[WorkflowDigest] = zio.aws.core.internal
      .optionalFromNullable(impl.digest())
      .map(value => zio.aws.omics.model.primitives.WorkflowDigest(value))
    override val creationTime: Optional[WorkflowTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => zio.aws.omics.model.primitives.WorkflowTimestamp(value))
    override val metadata
        : Optional[Map[WorkflowMetadataKey, WorkflowMetadataValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.omics.model.primitives.WorkflowMetadataKey(
                key
              ) -> zio.aws.omics.model.primitives.WorkflowMetadataValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.omics.model.WorkflowListItem
  ): zio.aws.omics.model.WorkflowListItem.ReadOnly = new Wrapper(impl)
}
