package zio.aws.opensearch
import zio.aws.opensearch.model.DeleteDomainResponse.ReadOnly
import zio.aws.opensearch.model.primitives.VersionString
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.opensearch.OpenSearchAsyncClient
import zio.stream.ZStream
import zio.aws.opensearch.model.{
  DeleteOutboundConnectionRequest,
  DeleteInboundConnectionRequest,
  DescribeDomainConfigRequest,
  AssociatePackageRequest,
  GetUpgradeHistoryRequest,
  DescribeReservedInstanceOfferingsRequest,
  CancelServiceSoftwareUpdateRequest,
  DescribePackagesRequest,
  DescribeInstanceTypeLimitsRequest,
  GetCompatibleVersionsRequest,
  ListTagsRequest,
  RejectInboundConnectionRequest,
  DescribeDomainAutoTunesRequest,
  UpdateDomainConfigRequest,
  DescribeInboundConnectionsRequest,
  ListPackagesForDomainRequest,
  DescribeDomainsRequest,
  DeletePackageRequest,
  ListVersionsRequest,
  GetPackageVersionHistoryRequest,
  ListInstanceTypeDetailsRequest,
  AcceptInboundConnectionRequest,
  CreatePackageRequest,
  AddTagsRequest,
  DescribeDomainChangeProgressRequest,
  ListDomainNamesRequest,
  DeleteDomainRequest,
  GetUpgradeStatusRequest,
  DescribeDomainRequest,
  StartServiceSoftwareUpdateRequest,
  CreateOutboundConnectionRequest,
  DescribeReservedInstancesRequest,
  CreateDomainRequest,
  PurchaseReservedInstanceOfferingRequest,
  UpgradeDomainRequest,
  DescribeOutboundConnectionsRequest,
  DissociatePackageRequest,
  RemoveTagsRequest,
  ListDomainsForPackageRequest,
  UpdatePackageRequest
}
object OpenSearchMock extends Mock[OpenSearch] {
  object DescribePackages
      extends Stream[
        DescribePackagesRequest,
        AwsError,
        zio.aws.opensearch.model.PackageDetails.ReadOnly
      ]
  object DescribePackagesPaginated
      extends Effect[
        DescribePackagesRequest,
        AwsError,
        zio.aws.opensearch.model.DescribePackagesResponse.ReadOnly
      ]
  object StartServiceSoftwareUpdate
      extends Effect[
        StartServiceSoftwareUpdateRequest,
        AwsError,
        zio.aws.opensearch.model.StartServiceSoftwareUpdateResponse.ReadOnly
      ]
  object GetCompatibleVersions
      extends Effect[
        GetCompatibleVersionsRequest,
        AwsError,
        zio.aws.opensearch.model.GetCompatibleVersionsResponse.ReadOnly
      ]
  object AssociatePackage
      extends Effect[
        AssociatePackageRequest,
        AwsError,
        zio.aws.opensearch.model.AssociatePackageResponse.ReadOnly
      ]
  object DescribeDomain
      extends Effect[
        DescribeDomainRequest,
        AwsError,
        zio.aws.opensearch.model.DescribeDomainResponse.ReadOnly
      ]
  object CreatePackage
      extends Effect[
        CreatePackageRequest,
        AwsError,
        zio.aws.opensearch.model.CreatePackageResponse.ReadOnly
      ]
  object ListTags
      extends Effect[
        ListTagsRequest,
        AwsError,
        zio.aws.opensearch.model.ListTagsResponse.ReadOnly
      ]
  object DeleteOutboundConnection
      extends Effect[
        DeleteOutboundConnectionRequest,
        AwsError,
        zio.aws.opensearch.model.DeleteOutboundConnectionResponse.ReadOnly
      ]
  object AddTags extends Effect[AddTagsRequest, AwsError, Unit]
  object DissociatePackage
      extends Effect[
        DissociatePackageRequest,
        AwsError,
        zio.aws.opensearch.model.DissociatePackageResponse.ReadOnly
      ]
  object UpdateDomainConfig
      extends Effect[
        UpdateDomainConfigRequest,
        AwsError,
        zio.aws.opensearch.model.UpdateDomainConfigResponse.ReadOnly
      ]
  object DescribeReservedInstances
      extends Stream[
        DescribeReservedInstancesRequest,
        AwsError,
        zio.aws.opensearch.model.ReservedInstance.ReadOnly
      ]
  object DescribeReservedInstancesPaginated
      extends Effect[
        DescribeReservedInstancesRequest,
        AwsError,
        zio.aws.opensearch.model.DescribeReservedInstancesResponse.ReadOnly
      ]
  object ListDomainsForPackage
      extends Stream[
        ListDomainsForPackageRequest,
        AwsError,
        zio.aws.opensearch.model.DomainPackageDetails.ReadOnly
      ]
  object ListDomainsForPackagePaginated
      extends Effect[
        ListDomainsForPackageRequest,
        AwsError,
        zio.aws.opensearch.model.ListDomainsForPackageResponse.ReadOnly
      ]
  object CreateOutboundConnection
      extends Effect[
        CreateOutboundConnectionRequest,
        AwsError,
        zio.aws.opensearch.model.CreateOutboundConnectionResponse.ReadOnly
      ]
  object UpgradeDomain
      extends Effect[
        UpgradeDomainRequest,
        AwsError,
        zio.aws.opensearch.model.UpgradeDomainResponse.ReadOnly
      ]
  object DescribeOutboundConnections
      extends Stream[
        DescribeOutboundConnectionsRequest,
        AwsError,
        zio.aws.opensearch.model.OutboundConnection.ReadOnly
      ]
  object DescribeOutboundConnectionsPaginated
      extends Effect[
        DescribeOutboundConnectionsRequest,
        AwsError,
        zio.aws.opensearch.model.DescribeOutboundConnectionsResponse.ReadOnly
      ]
  object DescribeDomainChangeProgress
      extends Effect[
        DescribeDomainChangeProgressRequest,
        AwsError,
        zio.aws.opensearch.model.DescribeDomainChangeProgressResponse.ReadOnly
      ]
  object RemoveTags extends Effect[RemoveTagsRequest, AwsError, Unit]
  object GetUpgradeHistory
      extends Stream[
        GetUpgradeHistoryRequest,
        AwsError,
        zio.aws.opensearch.model.UpgradeHistory.ReadOnly
      ]
  object GetUpgradeHistoryPaginated
      extends Effect[
        GetUpgradeHistoryRequest,
        AwsError,
        zio.aws.opensearch.model.GetUpgradeHistoryResponse.ReadOnly
      ]
  object CreateDomain
      extends Effect[
        CreateDomainRequest,
        AwsError,
        zio.aws.opensearch.model.CreateDomainResponse.ReadOnly
      ]
  object ListPackagesForDomain
      extends Stream[
        ListPackagesForDomainRequest,
        AwsError,
        zio.aws.opensearch.model.DomainPackageDetails.ReadOnly
      ]
  object ListPackagesForDomainPaginated
      extends Effect[
        ListPackagesForDomainRequest,
        AwsError,
        zio.aws.opensearch.model.ListPackagesForDomainResponse.ReadOnly
      ]
  object DescribeInboundConnections
      extends Stream[
        DescribeInboundConnectionsRequest,
        AwsError,
        zio.aws.opensearch.model.InboundConnection.ReadOnly
      ]
  object DescribeInboundConnectionsPaginated
      extends Effect[
        DescribeInboundConnectionsRequest,
        AwsError,
        zio.aws.opensearch.model.DescribeInboundConnectionsResponse.ReadOnly
      ]
  object ListVersions
      extends Stream[ListVersionsRequest, AwsError, VersionString]
  object ListVersionsPaginated
      extends Effect[
        ListVersionsRequest,
        AwsError,
        zio.aws.opensearch.model.ListVersionsResponse.ReadOnly
      ]
  object GetPackageVersionHistory
      extends Effect[
        GetPackageVersionHistoryRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.opensearch.model.GetPackageVersionHistoryResponse.ReadOnly,
          zio.aws.opensearch.model.PackageVersionHistory.ReadOnly
        ]
      ]
  object GetPackageVersionHistoryPaginated
      extends Effect[
        GetPackageVersionHistoryRequest,
        AwsError,
        zio.aws.opensearch.model.GetPackageVersionHistoryResponse.ReadOnly
      ]
  object CancelServiceSoftwareUpdate
      extends Effect[
        CancelServiceSoftwareUpdateRequest,
        AwsError,
        zio.aws.opensearch.model.CancelServiceSoftwareUpdateResponse.ReadOnly
      ]
  object DescribeDomainConfig
      extends Effect[
        DescribeDomainConfigRequest,
        AwsError,
        zio.aws.opensearch.model.DescribeDomainConfigResponse.ReadOnly
      ]
  object DescribeDomains
      extends Effect[
        DescribeDomainsRequest,
        AwsError,
        zio.aws.opensearch.model.DescribeDomainsResponse.ReadOnly
      ]
  object DescribeDomainAutoTunes
      extends Stream[
        DescribeDomainAutoTunesRequest,
        AwsError,
        zio.aws.opensearch.model.AutoTune.ReadOnly
      ]
  object DescribeDomainAutoTunesPaginated
      extends Effect[
        DescribeDomainAutoTunesRequest,
        AwsError,
        zio.aws.opensearch.model.DescribeDomainAutoTunesResponse.ReadOnly
      ]
  object ListInstanceTypeDetails
      extends Stream[
        ListInstanceTypeDetailsRequest,
        AwsError,
        zio.aws.opensearch.model.InstanceTypeDetails.ReadOnly
      ]
  object ListInstanceTypeDetailsPaginated
      extends Effect[
        ListInstanceTypeDetailsRequest,
        AwsError,
        zio.aws.opensearch.model.ListInstanceTypeDetailsResponse.ReadOnly
      ]
  object UpdatePackage
      extends Effect[
        UpdatePackageRequest,
        AwsError,
        zio.aws.opensearch.model.UpdatePackageResponse.ReadOnly
      ]
  object DeletePackage
      extends Effect[
        DeletePackageRequest,
        AwsError,
        zio.aws.opensearch.model.DeletePackageResponse.ReadOnly
      ]
  object DeleteDomain extends Effect[DeleteDomainRequest, AwsError, ReadOnly]
  object DescribeInstanceTypeLimits
      extends Effect[
        DescribeInstanceTypeLimitsRequest,
        AwsError,
        zio.aws.opensearch.model.DescribeInstanceTypeLimitsResponse.ReadOnly
      ]
  object AcceptInboundConnection
      extends Effect[
        AcceptInboundConnectionRequest,
        AwsError,
        zio.aws.opensearch.model.AcceptInboundConnectionResponse.ReadOnly
      ]
  object DeleteInboundConnection
      extends Effect[
        DeleteInboundConnectionRequest,
        AwsError,
        zio.aws.opensearch.model.DeleteInboundConnectionResponse.ReadOnly
      ]
  object PurchaseReservedInstanceOffering
      extends Effect[
        PurchaseReservedInstanceOfferingRequest,
        AwsError,
        zio.aws.opensearch.model.PurchaseReservedInstanceOfferingResponse.ReadOnly
      ]
  object GetUpgradeStatus
      extends Effect[
        GetUpgradeStatusRequest,
        AwsError,
        zio.aws.opensearch.model.GetUpgradeStatusResponse.ReadOnly
      ]
  object ListDomainNames
      extends Effect[
        ListDomainNamesRequest,
        AwsError,
        zio.aws.opensearch.model.ListDomainNamesResponse.ReadOnly
      ]
  object RejectInboundConnection
      extends Effect[
        RejectInboundConnectionRequest,
        AwsError,
        zio.aws.opensearch.model.RejectInboundConnectionResponse.ReadOnly
      ]
  object DescribeReservedInstanceOfferings
      extends Stream[
        DescribeReservedInstanceOfferingsRequest,
        AwsError,
        zio.aws.opensearch.model.ReservedInstanceOffering.ReadOnly
      ]
  object DescribeReservedInstanceOfferingsPaginated
      extends Effect[
        DescribeReservedInstanceOfferingsRequest,
        AwsError,
        zio.aws.opensearch.model.DescribeReservedInstanceOfferingsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, OpenSearch] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, OpenSearch] { rts =>
        ZIO.succeed {
          new OpenSearch {
            val api: OpenSearchAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): OpenSearch = this
            def describePackages(request: DescribePackagesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.opensearch.model.PackageDetails.ReadOnly
            ] = rts.unsafeRun(proxy(DescribePackages, request))
            def describePackagesPaginated(request: DescribePackagesRequest): IO[
              AwsError,
              zio.aws.opensearch.model.DescribePackagesResponse.ReadOnly
            ] = proxy(DescribePackagesPaginated, request)
            def startServiceSoftwareUpdate(
                request: StartServiceSoftwareUpdateRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.StartServiceSoftwareUpdateResponse.ReadOnly
            ] = proxy(StartServiceSoftwareUpdate, request)
            def getCompatibleVersions(
                request: GetCompatibleVersionsRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.GetCompatibleVersionsResponse.ReadOnly
            ] = proxy(GetCompatibleVersions, request)
            def associatePackage(request: AssociatePackageRequest): IO[
              AwsError,
              zio.aws.opensearch.model.AssociatePackageResponse.ReadOnly
            ] = proxy(AssociatePackage, request)
            def describeDomain(request: DescribeDomainRequest): IO[
              AwsError,
              zio.aws.opensearch.model.DescribeDomainResponse.ReadOnly
            ] = proxy(DescribeDomain, request)
            def createPackage(request: CreatePackageRequest): IO[
              AwsError,
              zio.aws.opensearch.model.CreatePackageResponse.ReadOnly
            ] = proxy(CreatePackage, request)
            def listTags(request: ListTagsRequest): IO[
              AwsError,
              zio.aws.opensearch.model.ListTagsResponse.ReadOnly
            ] = proxy(ListTags, request)
            def deleteOutboundConnection(
                request: DeleteOutboundConnectionRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.DeleteOutboundConnectionResponse.ReadOnly
            ] = proxy(DeleteOutboundConnection, request)
            def addTags(request: AddTagsRequest): IO[AwsError, Unit] =
              proxy(AddTags, request)
            def dissociatePackage(request: DissociatePackageRequest): IO[
              AwsError,
              zio.aws.opensearch.model.DissociatePackageResponse.ReadOnly
            ] = proxy(DissociatePackage, request)
            def updateDomainConfig(request: UpdateDomainConfigRequest): IO[
              AwsError,
              zio.aws.opensearch.model.UpdateDomainConfigResponse.ReadOnly
            ] = proxy(UpdateDomainConfig, request)
            def describeReservedInstances(
                request: DescribeReservedInstancesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.opensearch.model.ReservedInstance.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeReservedInstances, request))
            def describeReservedInstancesPaginated(
                request: DescribeReservedInstancesRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.DescribeReservedInstancesResponse.ReadOnly
            ] = proxy(DescribeReservedInstancesPaginated, request)
            def listDomainsForPackage(
                request: ListDomainsForPackageRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.opensearch.model.DomainPackageDetails.ReadOnly
            ] = rts.unsafeRun(proxy(ListDomainsForPackage, request))
            def listDomainsForPackagePaginated(
                request: ListDomainsForPackageRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.ListDomainsForPackageResponse.ReadOnly
            ] = proxy(ListDomainsForPackagePaginated, request)
            def createOutboundConnection(
                request: CreateOutboundConnectionRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.CreateOutboundConnectionResponse.ReadOnly
            ] = proxy(CreateOutboundConnection, request)
            def upgradeDomain(request: UpgradeDomainRequest): IO[
              AwsError,
              zio.aws.opensearch.model.UpgradeDomainResponse.ReadOnly
            ] = proxy(UpgradeDomain, request)
            def describeOutboundConnections(
                request: DescribeOutboundConnectionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.opensearch.model.OutboundConnection.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeOutboundConnections, request))
            def describeOutboundConnectionsPaginated(
                request: DescribeOutboundConnectionsRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.DescribeOutboundConnectionsResponse.ReadOnly
            ] = proxy(DescribeOutboundConnectionsPaginated, request)
            def describeDomainChangeProgress(
                request: DescribeDomainChangeProgressRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.DescribeDomainChangeProgressResponse.ReadOnly
            ] = proxy(DescribeDomainChangeProgress, request)
            def removeTags(request: RemoveTagsRequest): IO[AwsError, Unit] =
              proxy(RemoveTags, request)
            def getUpgradeHistory(request: GetUpgradeHistoryRequest): ZStream[
              Any,
              AwsError,
              zio.aws.opensearch.model.UpgradeHistory.ReadOnly
            ] = rts.unsafeRun(proxy(GetUpgradeHistory, request))
            def getUpgradeHistoryPaginated(
                request: GetUpgradeHistoryRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.GetUpgradeHistoryResponse.ReadOnly
            ] = proxy(GetUpgradeHistoryPaginated, request)
            def createDomain(request: CreateDomainRequest): IO[
              AwsError,
              zio.aws.opensearch.model.CreateDomainResponse.ReadOnly
            ] = proxy(CreateDomain, request)
            def listPackagesForDomain(
                request: ListPackagesForDomainRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.opensearch.model.DomainPackageDetails.ReadOnly
            ] = rts.unsafeRun(proxy(ListPackagesForDomain, request))
            def listPackagesForDomainPaginated(
                request: ListPackagesForDomainRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.ListPackagesForDomainResponse.ReadOnly
            ] = proxy(ListPackagesForDomainPaginated, request)
            def describeInboundConnections(
                request: DescribeInboundConnectionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.opensearch.model.InboundConnection.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeInboundConnections, request))
            def describeInboundConnectionsPaginated(
                request: DescribeInboundConnectionsRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.DescribeInboundConnectionsResponse.ReadOnly
            ] = proxy(DescribeInboundConnectionsPaginated, request)
            def listVersions(
                request: ListVersionsRequest
            ): ZStream[Any, AwsError, VersionString] =
              rts.unsafeRun(proxy(ListVersions, request))
            def listVersionsPaginated(request: ListVersionsRequest): IO[
              AwsError,
              zio.aws.opensearch.model.ListVersionsResponse.ReadOnly
            ] = proxy(ListVersionsPaginated, request)
            def getPackageVersionHistory(
                request: GetPackageVersionHistoryRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.opensearch.model.GetPackageVersionHistoryResponse.ReadOnly,
              zio.aws.opensearch.model.PackageVersionHistory.ReadOnly
            ]] = proxy(GetPackageVersionHistory, request)
            def getPackageVersionHistoryPaginated(
                request: GetPackageVersionHistoryRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.GetPackageVersionHistoryResponse.ReadOnly
            ] = proxy(GetPackageVersionHistoryPaginated, request)
            def cancelServiceSoftwareUpdate(
                request: CancelServiceSoftwareUpdateRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.CancelServiceSoftwareUpdateResponse.ReadOnly
            ] = proxy(CancelServiceSoftwareUpdate, request)
            def describeDomainConfig(request: DescribeDomainConfigRequest): IO[
              AwsError,
              zio.aws.opensearch.model.DescribeDomainConfigResponse.ReadOnly
            ] = proxy(DescribeDomainConfig, request)
            def describeDomains(request: DescribeDomainsRequest): IO[
              AwsError,
              zio.aws.opensearch.model.DescribeDomainsResponse.ReadOnly
            ] = proxy(DescribeDomains, request)
            def describeDomainAutoTunes(
                request: DescribeDomainAutoTunesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.opensearch.model.AutoTune.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeDomainAutoTunes, request))
            def describeDomainAutoTunesPaginated(
                request: DescribeDomainAutoTunesRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.DescribeDomainAutoTunesResponse.ReadOnly
            ] = proxy(DescribeDomainAutoTunesPaginated, request)
            def listInstanceTypeDetails(
                request: ListInstanceTypeDetailsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.opensearch.model.InstanceTypeDetails.ReadOnly
            ] = rts.unsafeRun(proxy(ListInstanceTypeDetails, request))
            def listInstanceTypeDetailsPaginated(
                request: ListInstanceTypeDetailsRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.ListInstanceTypeDetailsResponse.ReadOnly
            ] = proxy(ListInstanceTypeDetailsPaginated, request)
            def updatePackage(request: UpdatePackageRequest): IO[
              AwsError,
              zio.aws.opensearch.model.UpdatePackageResponse.ReadOnly
            ] = proxy(UpdatePackage, request)
            def deletePackage(request: DeletePackageRequest): IO[
              AwsError,
              zio.aws.opensearch.model.DeletePackageResponse.ReadOnly
            ] = proxy(DeletePackage, request)
            def deleteDomain(
                request: DeleteDomainRequest
            ): IO[AwsError, ReadOnly] = proxy(DeleteDomain, request)
            def describeInstanceTypeLimits(
                request: DescribeInstanceTypeLimitsRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.DescribeInstanceTypeLimitsResponse.ReadOnly
            ] = proxy(DescribeInstanceTypeLimits, request)
            def acceptInboundConnection(
                request: AcceptInboundConnectionRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.AcceptInboundConnectionResponse.ReadOnly
            ] = proxy(AcceptInboundConnection, request)
            def deleteInboundConnection(
                request: DeleteInboundConnectionRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.DeleteInboundConnectionResponse.ReadOnly
            ] = proxy(DeleteInboundConnection, request)
            def purchaseReservedInstanceOffering(
                request: PurchaseReservedInstanceOfferingRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.PurchaseReservedInstanceOfferingResponse.ReadOnly
            ] = proxy(PurchaseReservedInstanceOffering, request)
            def getUpgradeStatus(request: GetUpgradeStatusRequest): IO[
              AwsError,
              zio.aws.opensearch.model.GetUpgradeStatusResponse.ReadOnly
            ] = proxy(GetUpgradeStatus, request)
            def listDomainNames(request: ListDomainNamesRequest): IO[
              AwsError,
              zio.aws.opensearch.model.ListDomainNamesResponse.ReadOnly
            ] = proxy(ListDomainNames, request)
            def rejectInboundConnection(
                request: RejectInboundConnectionRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.RejectInboundConnectionResponse.ReadOnly
            ] = proxy(RejectInboundConnection, request)
            def describeReservedInstanceOfferings(
                request: DescribeReservedInstanceOfferingsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.opensearch.model.ReservedInstanceOffering.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeReservedInstanceOfferings, request))
            def describeReservedInstanceOfferingsPaginated(
                request: DescribeReservedInstanceOfferingsRequest
            ): IO[
              AwsError,
              zio.aws.opensearch.model.DescribeReservedInstanceOfferingsResponse.ReadOnly
            ] = proxy(DescribeReservedInstanceOfferingsPaginated, request)
          }
        }
      }
    }
  }
}
