package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{Region, DomainName, OwnerId}
import scala.jdk.CollectionConverters.*
final case class AWSDomainInformation(
    ownerId: Optional[OwnerId] = Optional.Absent,
    domainName: DomainName,
    region: Optional[Region] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AWSDomainInformation = {
    import AWSDomainInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AWSDomainInformation
      .builder()
      .optionallyWith(
        ownerId.map(value => OwnerId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.AWSDomainInformation.ReadOnly =
    zio.aws.opensearch.model.AWSDomainInformation.wrap(buildAwsValue())
}
object AWSDomainInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AWSDomainInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AWSDomainInformation =
      zio.aws.opensearch.model.AWSDomainInformation(
        ownerId.map(value => value),
        domainName,
        region.map(value => value)
      )
    def ownerId: Optional[OwnerId]
    def domainName: DomainName
    def region: Optional[Region]
    def getOwnerId: ZIO[Any, AwsError, OwnerId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AWSDomainInformation
  ) extends zio.aws.opensearch.model.AWSDomainInformation.ReadOnly {
    override val ownerId: Optional[OwnerId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.opensearch.model.primitives.OwnerId(value))
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.opensearch.model.primitives.Region(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AWSDomainInformation
  ): zio.aws.opensearch.model.AWSDomainInformation.ReadOnly = new Wrapper(impl)
}
