package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.ConnectionId
import scala.jdk.CollectionConverters.*
final case class AcceptInboundConnectionRequest(connectionId: ConnectionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionRequest = {
    import AcceptInboundConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.AcceptInboundConnectionRequest.ReadOnly =
    zio.aws.opensearch.model.AcceptInboundConnectionRequest
      .wrap(buildAwsValue())
}
object AcceptInboundConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AcceptInboundConnectionRequest =
      zio.aws.opensearch.model.AcceptInboundConnectionRequest(connectionId)
    def connectionId: ConnectionId
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionRequest
  ) extends zio.aws.opensearch.model.AcceptInboundConnectionRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.opensearch.model.primitives.ConnectionId(impl.connectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AcceptInboundConnectionRequest
  ): zio.aws.opensearch.model.AcceptInboundConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
