package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.{DomainName, PackageID}
import scala.jdk.CollectionConverters.*
final case class AssociatePackageRequest(
    packageID: PackageID,
    domainName: DomainName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AssociatePackageRequest = {
    import AssociatePackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AssociatePackageRequest
      .builder()
      .packageID(PackageID.unwrap(packageID): java.lang.String)
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.AssociatePackageRequest.ReadOnly =
    zio.aws.opensearch.model.AssociatePackageRequest.wrap(buildAwsValue())
}
object AssociatePackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AssociatePackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AssociatePackageRequest =
      zio.aws.opensearch.model.AssociatePackageRequest(packageID, domainName)
    def packageID: PackageID
    def domainName: DomainName
    def getPackageID: ZIO[Any, Nothing, PackageID] = ZIO.succeed(packageID)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AssociatePackageRequest
  ) extends zio.aws.opensearch.model.AssociatePackageRequest.ReadOnly {
    override val packageID: PackageID =
      zio.aws.opensearch.model.primitives.PackageID(impl.packageID())
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AssociatePackageRequest
  ): zio.aws.opensearch.model.AssociatePackageRequest.ReadOnly = new Wrapper(
    impl
  )
}
