package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociatePackageResponse(
    domainPackageDetails: Optional[
      zio.aws.opensearch.model.DomainPackageDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AssociatePackageResponse = {
    import AssociatePackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AssociatePackageResponse
      .builder()
      .optionallyWith(domainPackageDetails.map(value => value.buildAwsValue()))(
        _.domainPackageDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.AssociatePackageResponse.ReadOnly =
    zio.aws.opensearch.model.AssociatePackageResponse.wrap(buildAwsValue())
}
object AssociatePackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AssociatePackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AssociatePackageResponse =
      zio.aws.opensearch.model.AssociatePackageResponse(
        domainPackageDetails.map(value => value.asEditable)
      )
    def domainPackageDetails
        : Optional[zio.aws.opensearch.model.DomainPackageDetails.ReadOnly]
    def getDomainPackageDetails: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.DomainPackageDetails.ReadOnly
    ] = AwsError.unwrapOptionField("domainPackageDetails", domainPackageDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AssociatePackageResponse
  ) extends zio.aws.opensearch.model.AssociatePackageResponse.ReadOnly {
    override val domainPackageDetails
        : Optional[zio.aws.opensearch.model.DomainPackageDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainPackageDetails())
        .map(value => zio.aws.opensearch.model.DomainPackageDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AssociatePackageResponse
  ): zio.aws.opensearch.model.AssociatePackageResponse.ReadOnly = new Wrapper(
    impl
  )
}
