package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AutoTuneDetails(
    scheduledAutoTuneDetails: Optional[
      zio.aws.opensearch.model.ScheduledAutoTuneDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AutoTuneDetails = {
    import AutoTuneDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AutoTuneDetails
      .builder()
      .optionallyWith(
        scheduledAutoTuneDetails.map(value => value.buildAwsValue())
      )(_.scheduledAutoTuneDetails)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.AutoTuneDetails.ReadOnly =
    zio.aws.opensearch.model.AutoTuneDetails.wrap(buildAwsValue())
}
object AutoTuneDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AutoTuneDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AutoTuneDetails =
      zio.aws.opensearch.model.AutoTuneDetails(
        scheduledAutoTuneDetails.map(value => value.asEditable)
      )
    def scheduledAutoTuneDetails
        : Optional[zio.aws.opensearch.model.ScheduledAutoTuneDetails.ReadOnly]
    def getScheduledAutoTuneDetails: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.ScheduledAutoTuneDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "scheduledAutoTuneDetails",
      scheduledAutoTuneDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AutoTuneDetails
  ) extends zio.aws.opensearch.model.AutoTuneDetails.ReadOnly {
    override val scheduledAutoTuneDetails
        : Optional[zio.aws.opensearch.model.ScheduledAutoTuneDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledAutoTuneDetails())
        .map(value =>
          zio.aws.opensearch.model.ScheduledAutoTuneDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AutoTuneDetails
  ): zio.aws.opensearch.model.AutoTuneDetails.ReadOnly = new Wrapper(impl)
}
