package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AutoTuneOptionsInput(
    desiredState: Optional[zio.aws.opensearch.model.AutoTuneDesiredState] =
      Optional.Absent,
    maintenanceSchedules: Optional[
      Iterable[zio.aws.opensearch.model.AutoTuneMaintenanceSchedule]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsInput = {
    import AutoTuneOptionsInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsInput
      .builder()
      .optionallyWith(desiredState.map(value => value.unwrap))(_.desiredState)
      .optionallyWith(
        maintenanceSchedules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.maintenanceSchedules)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.AutoTuneOptionsInput.ReadOnly =
    zio.aws.opensearch.model.AutoTuneOptionsInput.wrap(buildAwsValue())
}
object AutoTuneOptionsInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AutoTuneOptionsInput =
      zio.aws.opensearch.model.AutoTuneOptionsInput(
        desiredState.map(value => value),
        maintenanceSchedules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def desiredState: Optional[zio.aws.opensearch.model.AutoTuneDesiredState]
    def maintenanceSchedules: Optional[
      List[zio.aws.opensearch.model.AutoTuneMaintenanceSchedule.ReadOnly]
    ]
    def getDesiredState
        : ZIO[Any, AwsError, zio.aws.opensearch.model.AutoTuneDesiredState] =
      AwsError.unwrapOptionField("desiredState", desiredState)
    def getMaintenanceSchedules: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.AutoTuneMaintenanceSchedule.ReadOnly
    ]] =
      AwsError.unwrapOptionField("maintenanceSchedules", maintenanceSchedules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsInput
  ) extends zio.aws.opensearch.model.AutoTuneOptionsInput.ReadOnly {
    override val desiredState
        : Optional[zio.aws.opensearch.model.AutoTuneDesiredState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredState())
        .map(value => zio.aws.opensearch.model.AutoTuneDesiredState.wrap(value))
    override val maintenanceSchedules: Optional[
      List[zio.aws.opensearch.model.AutoTuneMaintenanceSchedule.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceSchedules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearch.model.AutoTuneMaintenanceSchedule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsInput
  ): zio.aws.opensearch.model.AutoTuneOptionsInput.ReadOnly = new Wrapper(impl)
}
