package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AutoTuneOptionsStatus(
    options: Optional[zio.aws.opensearch.model.AutoTuneOptions] =
      Optional.Absent,
    status: Optional[zio.aws.opensearch.model.AutoTuneStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsStatus = {
    import AutoTuneOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsStatus
      .builder()
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.AutoTuneOptionsStatus.ReadOnly =
    zio.aws.opensearch.model.AutoTuneOptionsStatus.wrap(buildAwsValue())
}
object AutoTuneOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.AutoTuneOptionsStatus =
      zio.aws.opensearch.model.AutoTuneOptionsStatus(
        options.map(value => value.asEditable),
        status.map(value => value.asEditable)
      )
    def options: Optional[zio.aws.opensearch.model.AutoTuneOptions.ReadOnly]
    def status: Optional[zio.aws.opensearch.model.AutoTuneStatus.ReadOnly]
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.AutoTuneOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.opensearch.model.AutoTuneStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsStatus
  ) extends zio.aws.opensearch.model.AutoTuneOptionsStatus.ReadOnly {
    override val options
        : Optional[zio.aws.opensearch.model.AutoTuneOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value => zio.aws.opensearch.model.AutoTuneOptions.wrap(value))
    override val status
        : Optional[zio.aws.opensearch.model.AutoTuneStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.opensearch.model.AutoTuneStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsStatus
  ): zio.aws.opensearch.model.AutoTuneOptionsStatus.ReadOnly = new Wrapper(impl)
}
