package zio.aws.opensearch.model
import scala.jdk.CollectionConverters.*
sealed trait AutoTuneType {
  def unwrap: software.amazon.awssdk.services.opensearch.model.AutoTuneType
}
object AutoTuneType {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.AutoTuneType
  ): zio.aws.opensearch.model.AutoTuneType = value match {
    case software.amazon.awssdk.services.opensearch.model.AutoTuneType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.AutoTuneType.SCHEDULED_ACTION =>
      val r = SCHEDULED_ACTION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.AutoTuneType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.AutoTuneType =
      software.amazon.awssdk.services.opensearch.model.AutoTuneType.UNKNOWN_TO_SDK_VERSION
  }
  case object SCHEDULED_ACTION extends zio.aws.opensearch.model.AutoTuneType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.AutoTuneType =
      software.amazon.awssdk.services.opensearch.model.AutoTuneType.SCHEDULED_ACTION
  }
}
