package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CancelServiceSoftwareUpdateResponse(
    serviceSoftwareOptions: Optional[
      zio.aws.opensearch.model.ServiceSoftwareOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateResponse = {
    import CancelServiceSoftwareUpdateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateResponse
      .builder()
      .optionallyWith(
        serviceSoftwareOptions.map(value => value.buildAwsValue())
      )(_.serviceSoftwareOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.CancelServiceSoftwareUpdateResponse.ReadOnly =
    zio.aws.opensearch.model.CancelServiceSoftwareUpdateResponse
      .wrap(buildAwsValue())
}
object CancelServiceSoftwareUpdateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearch.model.CancelServiceSoftwareUpdateResponse =
      zio.aws.opensearch.model.CancelServiceSoftwareUpdateResponse(
        serviceSoftwareOptions.map(value => value.asEditable)
      )
    def serviceSoftwareOptions
        : Optional[zio.aws.opensearch.model.ServiceSoftwareOptions.ReadOnly]
    def getServiceSoftwareOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.ServiceSoftwareOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceSoftwareOptions",
      serviceSoftwareOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateResponse
  ) extends zio.aws.opensearch.model.CancelServiceSoftwareUpdateResponse.ReadOnly {
    override val serviceSoftwareOptions
        : Optional[zio.aws.opensearch.model.ServiceSoftwareOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceSoftwareOptions())
        .map(value =>
          zio.aws.opensearch.model.ServiceSoftwareOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.CancelServiceSoftwareUpdateResponse
  ): zio.aws.opensearch.model.CancelServiceSoftwareUpdateResponse.ReadOnly =
    new Wrapper(impl)
}
