package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{Message, GUID}
import scala.jdk.CollectionConverters.*
final case class ChangeProgressDetails(
    changeId: Optional[GUID] = Optional.Absent,
    message: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ChangeProgressDetails = {
    import ChangeProgressDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ChangeProgressDetails
      .builder()
      .optionallyWith(
        changeId.map(value => GUID.unwrap(value): java.lang.String)
      )(_.changeId)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ChangeProgressDetails.ReadOnly =
    zio.aws.opensearch.model.ChangeProgressDetails.wrap(buildAwsValue())
}
object ChangeProgressDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ChangeProgressDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ChangeProgressDetails =
      zio.aws.opensearch.model.ChangeProgressDetails(
        changeId.map(value => value),
        message.map(value => value)
      )
    def changeId: Optional[GUID]
    def message: Optional[Message]
    def getChangeId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField("changeId", changeId)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ChangeProgressDetails
  ) extends zio.aws.opensearch.model.ChangeProgressDetails.ReadOnly {
    override val changeId: Optional[GUID] = zio.aws.core.internal
      .optionalFromNullable(impl.changeId())
      .map(value => zio.aws.opensearch.model.primitives.GUID(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.opensearch.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ChangeProgressDetails
  ): zio.aws.opensearch.model.ChangeProgressDetails.ReadOnly = new Wrapper(impl)
}
