package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.{
  LastUpdated,
  Description,
  ChangeProgressStageStatus,
  ChangeProgressStageName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ChangeProgressStage(
    name: Optional[ChangeProgressStageName] = Optional.Absent,
    status: Optional[ChangeProgressStageStatus] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    lastUpdated: Optional[LastUpdated] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ChangeProgressStage = {
    import ChangeProgressStage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ChangeProgressStage
      .builder()
      .optionallyWith(
        name.map(value =>
          ChangeProgressStageName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        status.map(value =>
          ChangeProgressStageStatus.unwrap(value): java.lang.String
        )
      )(_.status)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        lastUpdated.map(value => LastUpdated.unwrap(value): Instant)
      )(_.lastUpdated)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ChangeProgressStage.ReadOnly =
    zio.aws.opensearch.model.ChangeProgressStage.wrap(buildAwsValue())
}
object ChangeProgressStage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ChangeProgressStage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ChangeProgressStage =
      zio.aws.opensearch.model.ChangeProgressStage(
        name.map(value => value),
        status.map(value => value),
        description.map(value => value),
        lastUpdated.map(value => value)
      )
    def name: Optional[ChangeProgressStageName]
    def status: Optional[ChangeProgressStageStatus]
    def description: Optional[Description]
    def lastUpdated: Optional[LastUpdated]
    def getName: ZIO[Any, AwsError, ChangeProgressStageName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, ChangeProgressStageStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLastUpdated: ZIO[Any, AwsError, LastUpdated] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ChangeProgressStage
  ) extends zio.aws.opensearch.model.ChangeProgressStage.ReadOnly {
    override val name: Optional[ChangeProgressStageName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.opensearch.model.primitives.ChangeProgressStageName(value)
      )
    override val status: Optional[ChangeProgressStageStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.opensearch.model.primitives.ChangeProgressStageStatus(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.opensearch.model.primitives.Description(value))
    override val lastUpdated: Optional[LastUpdated] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdated())
      .map(value => zio.aws.opensearch.model.primitives.LastUpdated(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ChangeProgressStage
  ): zio.aws.opensearch.model.ChangeProgressStage.ReadOnly = new Wrapper(impl)
}
