package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.{
  TotalNumberOfStages,
  UpdateTimestamp,
  GUID
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ChangeProgressStatusDetails(
    changeId: Optional[GUID] = Optional.Absent,
    startTime: Optional[UpdateTimestamp] = Optional.Absent,
    status: Optional[zio.aws.opensearch.model.OverallChangeStatus] =
      Optional.Absent,
    pendingProperties: Optional[Iterable[String]] = Optional.Absent,
    completedProperties: Optional[Iterable[String]] = Optional.Absent,
    totalNumberOfStages: Optional[TotalNumberOfStages] = Optional.Absent,
    changeProgressStages: Optional[
      Iterable[zio.aws.opensearch.model.ChangeProgressStage]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ChangeProgressStatusDetails = {
    import ChangeProgressStatusDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ChangeProgressStatusDetails
      .builder()
      .optionallyWith(
        changeId.map(value => GUID.unwrap(value): java.lang.String)
      )(_.changeId)
      .optionallyWith(
        startTime.map(value => UpdateTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        pendingProperties.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.pendingProperties)
      .optionallyWith(
        completedProperties.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.completedProperties)
      .optionallyWith(
        totalNumberOfStages.map(value =>
          TotalNumberOfStages.unwrap(value): Integer
        )
      )(_.totalNumberOfStages)
      .optionallyWith(
        changeProgressStages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.changeProgressStages)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.ChangeProgressStatusDetails.ReadOnly =
    zio.aws.opensearch.model.ChangeProgressStatusDetails.wrap(buildAwsValue())
}
object ChangeProgressStatusDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ChangeProgressStatusDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ChangeProgressStatusDetails =
      zio.aws.opensearch.model.ChangeProgressStatusDetails(
        changeId.map(value => value),
        startTime.map(value => value),
        status.map(value => value),
        pendingProperties.map(value => value),
        completedProperties.map(value => value),
        totalNumberOfStages.map(value => value),
        changeProgressStages.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def changeId: Optional[GUID]
    def startTime: Optional[UpdateTimestamp]
    def status: Optional[zio.aws.opensearch.model.OverallChangeStatus]
    def pendingProperties: Optional[List[String]]
    def completedProperties: Optional[List[String]]
    def totalNumberOfStages: Optional[TotalNumberOfStages]
    def changeProgressStages
        : Optional[List[zio.aws.opensearch.model.ChangeProgressStage.ReadOnly]]
    def getChangeId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField("changeId", changeId)
    def getStartTime: ZIO[Any, AwsError, UpdateTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.opensearch.model.OverallChangeStatus] =
      AwsError.unwrapOptionField("status", status)
    def getPendingProperties: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("pendingProperties", pendingProperties)
    def getCompletedProperties: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("completedProperties", completedProperties)
    def getTotalNumberOfStages: ZIO[Any, AwsError, TotalNumberOfStages] =
      AwsError.unwrapOptionField("totalNumberOfStages", totalNumberOfStages)
    def getChangeProgressStages: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.ChangeProgressStage.ReadOnly
    ]] =
      AwsError.unwrapOptionField("changeProgressStages", changeProgressStages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ChangeProgressStatusDetails
  ) extends zio.aws.opensearch.model.ChangeProgressStatusDetails.ReadOnly {
    override val changeId: Optional[GUID] = zio.aws.core.internal
      .optionalFromNullable(impl.changeId())
      .map(value => zio.aws.opensearch.model.primitives.GUID(value))
    override val startTime: Optional[UpdateTimestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.opensearch.model.primitives.UpdateTimestamp(value))
    override val status
        : Optional[zio.aws.opensearch.model.OverallChangeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.opensearch.model.OverallChangeStatus.wrap(value))
    override val pendingProperties: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingProperties())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val completedProperties: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completedProperties())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val totalNumberOfStages: Optional[TotalNumberOfStages] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalNumberOfStages())
        .map(value =>
          zio.aws.opensearch.model.primitives.TotalNumberOfStages(value)
        )
    override val changeProgressStages: Optional[
      List[zio.aws.opensearch.model.ChangeProgressStage.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.changeProgressStages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearch.model.ChangeProgressStage.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ChangeProgressStatusDetails
  ): zio.aws.opensearch.model.ChangeProgressStatusDetails.ReadOnly =
    new Wrapper(impl)
}
