package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.IntegerClass
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ClusterConfig(
    instanceType: Optional[
      zio.aws.opensearch.model.OpenSearchPartitionInstanceType
    ] = Optional.Absent,
    instanceCount: Optional[IntegerClass] = Optional.Absent,
    dedicatedMasterEnabled: Optional[Boolean] = Optional.Absent,
    zoneAwarenessEnabled: Optional[Boolean] = Optional.Absent,
    zoneAwarenessConfig: Optional[
      zio.aws.opensearch.model.ZoneAwarenessConfig
    ] = Optional.Absent,
    dedicatedMasterType: Optional[
      zio.aws.opensearch.model.OpenSearchPartitionInstanceType
    ] = Optional.Absent,
    dedicatedMasterCount: Optional[IntegerClass] = Optional.Absent,
    warmEnabled: Optional[Boolean] = Optional.Absent,
    warmType: Optional[
      zio.aws.opensearch.model.OpenSearchWarmPartitionInstanceType
    ] = Optional.Absent,
    warmCount: Optional[IntegerClass] = Optional.Absent,
    coldStorageOptions: Optional[zio.aws.opensearch.model.ColdStorageOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ClusterConfig = {
    import ClusterConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ClusterConfig
      .builder()
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        instanceCount.map(value => IntegerClass.unwrap(value): Integer)
      )(_.instanceCount)
      .optionallyWith(
        dedicatedMasterEnabled.map(value => value: java.lang.Boolean)
      )(_.dedicatedMasterEnabled)
      .optionallyWith(
        zoneAwarenessEnabled.map(value => value: java.lang.Boolean)
      )(_.zoneAwarenessEnabled)
      .optionallyWith(zoneAwarenessConfig.map(value => value.buildAwsValue()))(
        _.zoneAwarenessConfig
      )
      .optionallyWith(dedicatedMasterType.map(value => value.unwrap))(
        _.dedicatedMasterType
      )
      .optionallyWith(
        dedicatedMasterCount.map(value => IntegerClass.unwrap(value): Integer)
      )(_.dedicatedMasterCount)
      .optionallyWith(warmEnabled.map(value => value: java.lang.Boolean))(
        _.warmEnabled
      )
      .optionallyWith(warmType.map(value => value.unwrap))(_.warmType)
      .optionallyWith(
        warmCount.map(value => IntegerClass.unwrap(value): Integer)
      )(_.warmCount)
      .optionallyWith(coldStorageOptions.map(value => value.buildAwsValue()))(
        _.coldStorageOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ClusterConfig.ReadOnly =
    zio.aws.opensearch.model.ClusterConfig.wrap(buildAwsValue())
}
object ClusterConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ClusterConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ClusterConfig =
      zio.aws.opensearch.model.ClusterConfig(
        instanceType.map(value => value),
        instanceCount.map(value => value),
        dedicatedMasterEnabled.map(value => value),
        zoneAwarenessEnabled.map(value => value),
        zoneAwarenessConfig.map(value => value.asEditable),
        dedicatedMasterType.map(value => value),
        dedicatedMasterCount.map(value => value),
        warmEnabled.map(value => value),
        warmType.map(value => value),
        warmCount.map(value => value),
        coldStorageOptions.map(value => value.asEditable)
      )
    def instanceType
        : Optional[zio.aws.opensearch.model.OpenSearchPartitionInstanceType]
    def instanceCount: Optional[IntegerClass]
    def dedicatedMasterEnabled: Optional[Boolean]
    def zoneAwarenessEnabled: Optional[Boolean]
    def zoneAwarenessConfig
        : Optional[zio.aws.opensearch.model.ZoneAwarenessConfig.ReadOnly]
    def dedicatedMasterType
        : Optional[zio.aws.opensearch.model.OpenSearchPartitionInstanceType]
    def dedicatedMasterCount: Optional[IntegerClass]
    def warmEnabled: Optional[Boolean]
    def warmType
        : Optional[zio.aws.opensearch.model.OpenSearchWarmPartitionInstanceType]
    def warmCount: Optional[IntegerClass]
    def coldStorageOptions
        : Optional[zio.aws.opensearch.model.ColdStorageOptions.ReadOnly]
    def getInstanceType: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.OpenSearchPartitionInstanceType
    ] = AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstanceCount: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getDedicatedMasterEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("dedicatedMasterEnabled", dedicatedMasterEnabled)
    def getZoneAwarenessEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("zoneAwarenessEnabled", zoneAwarenessEnabled)
    def getZoneAwarenessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.ZoneAwarenessConfig.ReadOnly
    ] = AwsError.unwrapOptionField("zoneAwarenessConfig", zoneAwarenessConfig)
    def getDedicatedMasterType: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.OpenSearchPartitionInstanceType
    ] = AwsError.unwrapOptionField("dedicatedMasterType", dedicatedMasterType)
    def getDedicatedMasterCount: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("dedicatedMasterCount", dedicatedMasterCount)
    def getWarmEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("warmEnabled", warmEnabled)
    def getWarmType: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.OpenSearchWarmPartitionInstanceType
    ] = AwsError.unwrapOptionField("warmType", warmType)
    def getWarmCount: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("warmCount", warmCount)
    def getColdStorageOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.ColdStorageOptions.ReadOnly
    ] = AwsError.unwrapOptionField("coldStorageOptions", coldStorageOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ClusterConfig
  ) extends zio.aws.opensearch.model.ClusterConfig.ReadOnly {
    override val instanceType
        : Optional[zio.aws.opensearch.model.OpenSearchPartitionInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value =>
          zio.aws.opensearch.model.OpenSearchPartitionInstanceType.wrap(value)
        )
    override val instanceCount: Optional[IntegerClass] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => zio.aws.opensearch.model.primitives.IntegerClass(value))
    override val dedicatedMasterEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedMasterEnabled())
        .map(value => value: Boolean)
    override val zoneAwarenessEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.zoneAwarenessEnabled())
      .map(value => value: Boolean)
    override val zoneAwarenessConfig
        : Optional[zio.aws.opensearch.model.ZoneAwarenessConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.zoneAwarenessConfig())
        .map(value => zio.aws.opensearch.model.ZoneAwarenessConfig.wrap(value))
    override val dedicatedMasterType
        : Optional[zio.aws.opensearch.model.OpenSearchPartitionInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedMasterType())
        .map(value =>
          zio.aws.opensearch.model.OpenSearchPartitionInstanceType.wrap(value)
        )
    override val dedicatedMasterCount: Optional[IntegerClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedMasterCount())
        .map(value => zio.aws.opensearch.model.primitives.IntegerClass(value))
    override val warmEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.warmEnabled())
      .map(value => value: Boolean)
    override val warmType: Optional[
      zio.aws.opensearch.model.OpenSearchWarmPartitionInstanceType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.warmType())
      .map(value =>
        zio.aws.opensearch.model.OpenSearchWarmPartitionInstanceType.wrap(value)
      )
    override val warmCount: Optional[IntegerClass] = zio.aws.core.internal
      .optionalFromNullable(impl.warmCount())
      .map(value => zio.aws.opensearch.model.primitives.IntegerClass(value))
    override val coldStorageOptions
        : Optional[zio.aws.opensearch.model.ColdStorageOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coldStorageOptions())
        .map(value => zio.aws.opensearch.model.ColdStorageOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ClusterConfig
  ): zio.aws.opensearch.model.ClusterConfig.ReadOnly = new Wrapper(impl)
}
