package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ClusterConfigStatus(
    options: zio.aws.opensearch.model.ClusterConfig,
    status: zio.aws.opensearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.ClusterConfigStatus = {
    import ClusterConfigStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.ClusterConfigStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.ClusterConfigStatus.ReadOnly =
    zio.aws.opensearch.model.ClusterConfigStatus.wrap(buildAwsValue())
}
object ClusterConfigStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.ClusterConfigStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.ClusterConfigStatus =
      zio.aws.opensearch.model
        .ClusterConfigStatus(options.asEditable, status.asEditable)
    def options: zio.aws.opensearch.model.ClusterConfig.ReadOnly
    def status: zio.aws.opensearch.model.OptionStatus.ReadOnly
    def getOptions
        : ZIO[Any, Nothing, zio.aws.opensearch.model.ClusterConfig.ReadOnly] =
      ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.opensearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.ClusterConfigStatus
  ) extends zio.aws.opensearch.model.ClusterConfigStatus.ReadOnly {
    override val options: zio.aws.opensearch.model.ClusterConfig.ReadOnly =
      zio.aws.opensearch.model.ClusterConfig.wrap(impl.options())
    override val status: zio.aws.opensearch.model.OptionStatus.ReadOnly =
      zio.aws.opensearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.ClusterConfigStatus
  ): zio.aws.opensearch.model.ClusterConfigStatus.ReadOnly = new Wrapper(impl)
}
