package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteDomainResponse(
    domainStatus: Optional[zio.aws.opensearch.model.DomainStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DeleteDomainResponse = {
    import DeleteDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DeleteDomainResponse
      .builder()
      .optionallyWith(domainStatus.map(value => value.buildAwsValue()))(
        _.domainStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DeleteDomainResponse.ReadOnly =
    zio.aws.opensearch.model.DeleteDomainResponse.wrap(buildAwsValue())
}
object DeleteDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DeleteDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DeleteDomainResponse =
      zio.aws.opensearch.model
        .DeleteDomainResponse(domainStatus.map(value => value.asEditable))
    def domainStatus: Optional[zio.aws.opensearch.model.DomainStatus.ReadOnly]
    def getDomainStatus
        : ZIO[Any, AwsError, zio.aws.opensearch.model.DomainStatus.ReadOnly] =
      AwsError.unwrapOptionField("domainStatus", domainStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DeleteDomainResponse
  ) extends zio.aws.opensearch.model.DeleteDomainResponse.ReadOnly {
    override val domainStatus
        : Optional[zio.aws.opensearch.model.DomainStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainStatus())
        .map(value => zio.aws.opensearch.model.DomainStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DeleteDomainResponse
  ): zio.aws.opensearch.model.DeleteDomainResponse.ReadOnly = new Wrapper(impl)
}
