package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.ConnectionId
import scala.jdk.CollectionConverters.*
final case class DeleteInboundConnectionRequest(connectionId: ConnectionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionRequest = {
    import DeleteInboundConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DeleteInboundConnectionRequest.ReadOnly =
    zio.aws.opensearch.model.DeleteInboundConnectionRequest
      .wrap(buildAwsValue())
}
object DeleteInboundConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DeleteInboundConnectionRequest =
      zio.aws.opensearch.model.DeleteInboundConnectionRequest(connectionId)
    def connectionId: ConnectionId
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionRequest
  ) extends zio.aws.opensearch.model.DeleteInboundConnectionRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.opensearch.model.primitives.ConnectionId(impl.connectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionRequest
  ): zio.aws.opensearch.model.DeleteInboundConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
