package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteInboundConnectionResponse(
    connection: Optional[zio.aws.opensearch.model.InboundConnection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionResponse = {
    import DeleteInboundConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionResponse
      .builder()
      .optionallyWith(connection.map(value => value.buildAwsValue()))(
        _.connection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DeleteInboundConnectionResponse.ReadOnly =
    zio.aws.opensearch.model.DeleteInboundConnectionResponse
      .wrap(buildAwsValue())
}
object DeleteInboundConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DeleteInboundConnectionResponse =
      zio.aws.opensearch.model.DeleteInboundConnectionResponse(
        connection.map(value => value.asEditable)
      )
    def connection
        : Optional[zio.aws.opensearch.model.InboundConnection.ReadOnly]
    def getConnection: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.InboundConnection.ReadOnly
    ] = AwsError.unwrapOptionField("connection", connection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionResponse
  ) extends zio.aws.opensearch.model.DeleteInboundConnectionResponse.ReadOnly {
    override val connection
        : Optional[zio.aws.opensearch.model.InboundConnection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connection())
        .map(value => zio.aws.opensearch.model.InboundConnection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DeleteInboundConnectionResponse
  ): zio.aws.opensearch.model.DeleteInboundConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
