package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.ConnectionId
import scala.jdk.CollectionConverters.*
final case class DeleteOutboundConnectionRequest(connectionId: ConnectionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionRequest = {
    import DeleteOutboundConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionRequest
      .builder()
      .connectionId(ConnectionId.unwrap(connectionId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DeleteOutboundConnectionRequest.ReadOnly =
    zio.aws.opensearch.model.DeleteOutboundConnectionRequest
      .wrap(buildAwsValue())
}
object DeleteOutboundConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DeleteOutboundConnectionRequest =
      zio.aws.opensearch.model.DeleteOutboundConnectionRequest(connectionId)
    def connectionId: ConnectionId
    def getConnectionId: ZIO[Any, Nothing, ConnectionId] =
      ZIO.succeed(connectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionRequest
  ) extends zio.aws.opensearch.model.DeleteOutboundConnectionRequest.ReadOnly {
    override val connectionId: ConnectionId =
      zio.aws.opensearch.model.primitives.ConnectionId(impl.connectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionRequest
  ): zio.aws.opensearch.model.DeleteOutboundConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
