package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteOutboundConnectionResponse(
    connection: Optional[zio.aws.opensearch.model.OutboundConnection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionResponse = {
    import DeleteOutboundConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionResponse
      .builder()
      .optionallyWith(connection.map(value => value.buildAwsValue()))(
        _.connection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DeleteOutboundConnectionResponse.ReadOnly =
    zio.aws.opensearch.model.DeleteOutboundConnectionResponse
      .wrap(buildAwsValue())
}
object DeleteOutboundConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DeleteOutboundConnectionResponse =
      zio.aws.opensearch.model.DeleteOutboundConnectionResponse(
        connection.map(value => value.asEditable)
      )
    def connection
        : Optional[zio.aws.opensearch.model.OutboundConnection.ReadOnly]
    def getConnection: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.OutboundConnection.ReadOnly
    ] = AwsError.unwrapOptionField("connection", connection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionResponse
  ) extends zio.aws.opensearch.model.DeleteOutboundConnectionResponse.ReadOnly {
    override val connection
        : Optional[zio.aws.opensearch.model.OutboundConnection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connection())
        .map(value => zio.aws.opensearch.model.OutboundConnection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DeleteOutboundConnectionResponse
  ): zio.aws.opensearch.model.DeleteOutboundConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
