package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.PackageID
import scala.jdk.CollectionConverters.*
final case class DeletePackageRequest(packageID: PackageID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DeletePackageRequest = {
    import DeletePackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DeletePackageRequest
      .builder()
      .packageID(PackageID.unwrap(packageID): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DeletePackageRequest.ReadOnly =
    zio.aws.opensearch.model.DeletePackageRequest.wrap(buildAwsValue())
}
object DeletePackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DeletePackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DeletePackageRequest =
      zio.aws.opensearch.model.DeletePackageRequest(packageID)
    def packageID: PackageID
    def getPackageID: ZIO[Any, Nothing, PackageID] = ZIO.succeed(packageID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DeletePackageRequest
  ) extends zio.aws.opensearch.model.DeletePackageRequest.ReadOnly {
    override val packageID: PackageID =
      zio.aws.opensearch.model.primitives.PackageID(impl.packageID())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DeletePackageRequest
  ): zio.aws.opensearch.model.DeletePackageRequest.ReadOnly = new Wrapper(impl)
}
