package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class DescribeDomainAutoTunesResponse(
    autoTunes: Optional[Iterable[zio.aws.opensearch.model.AutoTune]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse = {
    import DescribeDomainAutoTunesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse
      .builder()
      .optionallyWith(
        autoTunes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.autoTunes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeDomainAutoTunesResponse.ReadOnly =
    zio.aws.opensearch.model.DescribeDomainAutoTunesResponse
      .wrap(buildAwsValue())
}
object DescribeDomainAutoTunesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribeDomainAutoTunesResponse =
      zio.aws.opensearch.model.DescribeDomainAutoTunesResponse(
        autoTunes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def autoTunes: Optional[List[zio.aws.opensearch.model.AutoTune.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAutoTunes
        : ZIO[Any, AwsError, List[zio.aws.opensearch.model.AutoTune.ReadOnly]] =
      AwsError.unwrapOptionField("autoTunes", autoTunes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse
  ) extends zio.aws.opensearch.model.DescribeDomainAutoTunesResponse.ReadOnly {
    override val autoTunes
        : Optional[List[zio.aws.opensearch.model.AutoTune.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoTunes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.AutoTune.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.opensearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainAutoTunesResponse
  ): zio.aws.opensearch.model.DescribeDomainAutoTunesResponse.ReadOnly =
    new Wrapper(impl)
}
