package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeDomainChangeProgressResponse(
    changeProgressStatus: Optional[
      zio.aws.opensearch.model.ChangeProgressStatusDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressResponse = {
    import DescribeDomainChangeProgressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressResponse
      .builder()
      .optionallyWith(changeProgressStatus.map(value => value.buildAwsValue()))(
        _.changeProgressStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeDomainChangeProgressResponse.ReadOnly =
    zio.aws.opensearch.model.DescribeDomainChangeProgressResponse
      .wrap(buildAwsValue())
}
object DescribeDomainChangeProgressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearch.model.DescribeDomainChangeProgressResponse =
      zio.aws.opensearch.model.DescribeDomainChangeProgressResponse(
        changeProgressStatus.map(value => value.asEditable)
      )
    def changeProgressStatus: Optional[
      zio.aws.opensearch.model.ChangeProgressStatusDetails.ReadOnly
    ]
    def getChangeProgressStatus: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.ChangeProgressStatusDetails.ReadOnly
    ] = AwsError.unwrapOptionField("changeProgressStatus", changeProgressStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressResponse
  ) extends zio.aws.opensearch.model.DescribeDomainChangeProgressResponse.ReadOnly {
    override val changeProgressStatus: Optional[
      zio.aws.opensearch.model.ChangeProgressStatusDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.changeProgressStatus())
      .map(value =>
        zio.aws.opensearch.model.ChangeProgressStatusDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainChangeProgressResponse
  ): zio.aws.opensearch.model.DescribeDomainChangeProgressResponse.ReadOnly =
    new Wrapper(impl)
}
