package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeDomainConfigResponse(
    domainConfig: zio.aws.opensearch.model.DomainConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigResponse = {
    import DescribeDomainConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigResponse
      .builder()
      .domainConfig(domainConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeDomainConfigResponse.ReadOnly =
    zio.aws.opensearch.model.DescribeDomainConfigResponse.wrap(buildAwsValue())
}
object DescribeDomainConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribeDomainConfigResponse =
      zio.aws.opensearch.model
        .DescribeDomainConfigResponse(domainConfig.asEditable)
    def domainConfig: zio.aws.opensearch.model.DomainConfig.ReadOnly
    def getDomainConfig
        : ZIO[Any, Nothing, zio.aws.opensearch.model.DomainConfig.ReadOnly] =
      ZIO.succeed(domainConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigResponse
  ) extends zio.aws.opensearch.model.DescribeDomainConfigResponse.ReadOnly {
    override val domainConfig: zio.aws.opensearch.model.DomainConfig.ReadOnly =
      zio.aws.opensearch.model.DomainConfig.wrap(impl.domainConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainConfigResponse
  ): zio.aws.opensearch.model.DescribeDomainConfigResponse.ReadOnly =
    new Wrapper(impl)
}
