package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeDomainsResponse(
    domainStatusList: Iterable[zio.aws.opensearch.model.DomainStatus]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeDomainsResponse = {
    import DescribeDomainsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeDomainsResponse
      .builder()
      .domainStatusList(domainStatusList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DescribeDomainsResponse.ReadOnly =
    zio.aws.opensearch.model.DescribeDomainsResponse.wrap(buildAwsValue())
}
object DescribeDomainsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeDomainsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribeDomainsResponse =
      zio.aws.opensearch.model.DescribeDomainsResponse(domainStatusList.map {
        item =>
          item.asEditable
      })
    def domainStatusList: List[zio.aws.opensearch.model.DomainStatus.ReadOnly]
    def getDomainStatusList: ZIO[Any, Nothing, List[
      zio.aws.opensearch.model.DomainStatus.ReadOnly
    ]] = ZIO.succeed(domainStatusList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainsResponse
  ) extends zio.aws.opensearch.model.DescribeDomainsResponse.ReadOnly {
    override val domainStatusList
        : List[zio.aws.opensearch.model.DomainStatus.ReadOnly] = impl
      .domainStatusList()
      .asScala
      .map { item =>
        zio.aws.opensearch.model.DomainStatus.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeDomainsResponse
  ): zio.aws.opensearch.model.DescribeDomainsResponse.ReadOnly = new Wrapper(
    impl
  )
}
