package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class DescribeInboundConnectionsResponse(
    connections: Optional[
      Iterable[zio.aws.opensearch.model.InboundConnection]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse = {
    import DescribeInboundConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse
      .builder()
      .optionallyWith(
        connections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connections)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeInboundConnectionsResponse.ReadOnly =
    zio.aws.opensearch.model.DescribeInboundConnectionsResponse
      .wrap(buildAwsValue())
}
object DescribeInboundConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearch.model.DescribeInboundConnectionsResponse =
      zio.aws.opensearch.model.DescribeInboundConnectionsResponse(
        connections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def connections
        : Optional[List[zio.aws.opensearch.model.InboundConnection.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getConnections: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.InboundConnection.ReadOnly
    ]] = AwsError.unwrapOptionField("connections", connections)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse
  ) extends zio.aws.opensearch.model.DescribeInboundConnectionsResponse.ReadOnly {
    override val connections
        : Optional[List[zio.aws.opensearch.model.InboundConnection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.InboundConnection.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.opensearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse
  ): zio.aws.opensearch.model.DescribeInboundConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
