package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.InstanceRole
import scala.jdk.CollectionConverters.*
final case class DescribeInstanceTypeLimitsResponse(
    limitsByRole: Optional[Map[InstanceRole, zio.aws.opensearch.model.Limits]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsResponse = {
    import DescribeInstanceTypeLimitsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsResponse
      .builder()
      .optionallyWith(
        limitsByRole.map(value =>
          value
            .map({ case (key, value) =>
              (InstanceRole.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.limitsByRole)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeInstanceTypeLimitsResponse.ReadOnly =
    zio.aws.opensearch.model.DescribeInstanceTypeLimitsResponse
      .wrap(buildAwsValue())
}
object DescribeInstanceTypeLimitsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.opensearch.model.DescribeInstanceTypeLimitsResponse =
      zio.aws.opensearch.model.DescribeInstanceTypeLimitsResponse(
        limitsByRole.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def limitsByRole
        : Optional[Map[InstanceRole, zio.aws.opensearch.model.Limits.ReadOnly]]
    def getLimitsByRole: ZIO[Any, AwsError, Map[
      InstanceRole,
      zio.aws.opensearch.model.Limits.ReadOnly
    ]] = AwsError.unwrapOptionField("limitsByRole", limitsByRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsResponse
  ) extends zio.aws.opensearch.model.DescribeInstanceTypeLimitsResponse.ReadOnly {
    override val limitsByRole: Optional[
      Map[InstanceRole, zio.aws.opensearch.model.Limits.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.limitsByRole())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.opensearch.model.primitives
              .InstanceRole(key) -> zio.aws.opensearch.model.Limits.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeInstanceTypeLimitsResponse
  ): zio.aws.opensearch.model.DescribeInstanceTypeLimitsResponse.ReadOnly =
    new Wrapper(impl)
}
