package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.DescribePackagesFilterValue
import scala.jdk.CollectionConverters.*
final case class DescribePackagesFilter(
    name: Optional[zio.aws.opensearch.model.DescribePackagesFilterName] =
      Optional.Absent,
    value: Optional[Iterable[DescribePackagesFilterValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribePackagesFilter = {
    import DescribePackagesFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribePackagesFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        value.map(value =>
          value.map { item =>
            DescribePackagesFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DescribePackagesFilter.ReadOnly =
    zio.aws.opensearch.model.DescribePackagesFilter.wrap(buildAwsValue())
}
object DescribePackagesFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribePackagesFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribePackagesFilter =
      zio.aws.opensearch.model.DescribePackagesFilter(
        name.map(value => value),
        value.map(value => value)
      )
    def name: Optional[zio.aws.opensearch.model.DescribePackagesFilterName]
    def value: Optional[List[DescribePackagesFilterValue]]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.DescribePackagesFilterName
    ] = AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, List[DescribePackagesFilterValue]] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribePackagesFilter
  ) extends zio.aws.opensearch.model.DescribePackagesFilter.ReadOnly {
    override val name
        : Optional[zio.aws.opensearch.model.DescribePackagesFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.opensearch.model.DescribePackagesFilterName.wrap(value)
        )
    override val value: Optional[List[DescribePackagesFilterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.primitives
              .DescribePackagesFilterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribePackagesFilter
  ): zio.aws.opensearch.model.DescribePackagesFilter.ReadOnly = new Wrapper(
    impl
  )
}
