package zio.aws.opensearch.model
import scala.jdk.CollectionConverters.*
sealed trait DescribePackagesFilterName {
  def unwrap: software.amazon.awssdk.services.opensearch.model.DescribePackagesFilterName
}
object DescribePackagesFilterName {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.DescribePackagesFilterName
  ): zio.aws.opensearch.model.DescribePackagesFilterName = value match {
    case software.amazon.awssdk.services.opensearch.model.DescribePackagesFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.DescribePackagesFilterName.PACKAGE_ID =>
      val r = PackageID
      r
    case software.amazon.awssdk.services.opensearch.model.DescribePackagesFilterName.PACKAGE_NAME =>
      val r = PackageName
      r
    case software.amazon.awssdk.services.opensearch.model.DescribePackagesFilterName.PACKAGE_STATUS =>
      val r = PackageStatus
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.opensearch.model.DescribePackagesFilterName {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.DescribePackagesFilterName =
      software.amazon.awssdk.services.opensearch.model.DescribePackagesFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object PackageID
      extends zio.aws.opensearch.model.DescribePackagesFilterName {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.DescribePackagesFilterName =
      software.amazon.awssdk.services.opensearch.model.DescribePackagesFilterName.PACKAGE_ID
  }
  case object PackageName
      extends zio.aws.opensearch.model.DescribePackagesFilterName {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.DescribePackagesFilterName =
      software.amazon.awssdk.services.opensearch.model.DescribePackagesFilterName.PACKAGE_NAME
  }
  case object PackageStatus
      extends zio.aws.opensearch.model.DescribePackagesFilterName {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.DescribePackagesFilterName =
      software.amazon.awssdk.services.opensearch.model.DescribePackagesFilterName.PACKAGE_STATUS
  }
}
