package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.{NextToken, MaxResults, GUID}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeReservedInstancesRequest(
    reservedInstanceId: Optional[GUID] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest = {
    import DescribeReservedInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest
      .builder()
      .optionallyWith(
        reservedInstanceId.map(value => GUID.unwrap(value): java.lang.String)
      )(_.reservedInstanceId)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeReservedInstancesRequest.ReadOnly =
    zio.aws.opensearch.model.DescribeReservedInstancesRequest
      .wrap(buildAwsValue())
}
object DescribeReservedInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribeReservedInstancesRequest =
      zio.aws.opensearch.model.DescribeReservedInstancesRequest(
        reservedInstanceId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def reservedInstanceId: Optional[GUID]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getReservedInstanceId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField("reservedInstanceId", reservedInstanceId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest
  ) extends zio.aws.opensearch.model.DescribeReservedInstancesRequest.ReadOnly {
    override val reservedInstanceId: Optional[GUID] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedInstanceId())
      .map(value => zio.aws.opensearch.model.primitives.GUID(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.opensearch.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.opensearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesRequest
  ): zio.aws.opensearch.model.DescribeReservedInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
