package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeReservedInstancesResponse(
    nextToken: Optional[String] = Optional.Absent,
    reservedInstances: Optional[
      Iterable[zio.aws.opensearch.model.ReservedInstance]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse = {
    import DescribeReservedInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        reservedInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedInstances)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.DescribeReservedInstancesResponse.ReadOnly =
    zio.aws.opensearch.model.DescribeReservedInstancesResponse
      .wrap(buildAwsValue())
}
object DescribeReservedInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DescribeReservedInstancesResponse =
      zio.aws.opensearch.model.DescribeReservedInstancesResponse(
        nextToken.map(value => value),
        reservedInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def reservedInstances
        : Optional[List[zio.aws.opensearch.model.ReservedInstance.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReservedInstances: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.ReservedInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("reservedInstances", reservedInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse
  ) extends zio.aws.opensearch.model.DescribeReservedInstancesResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val reservedInstances
        : Optional[List[zio.aws.opensearch.model.ReservedInstance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedInstances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.opensearch.model.ReservedInstance.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DescribeReservedInstancesResponse
  ): zio.aws.opensearch.model.DescribeReservedInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
