package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DomainConfig(
    engineVersion: Optional[zio.aws.opensearch.model.VersionStatus] =
      Optional.Absent,
    clusterConfig: Optional[zio.aws.opensearch.model.ClusterConfigStatus] =
      Optional.Absent,
    ebsOptions: Optional[zio.aws.opensearch.model.EBSOptionsStatus] =
      Optional.Absent,
    accessPolicies: Optional[zio.aws.opensearch.model.AccessPoliciesStatus] =
      Optional.Absent,
    snapshotOptions: Optional[zio.aws.opensearch.model.SnapshotOptionsStatus] =
      Optional.Absent,
    vpcOptions: Optional[zio.aws.opensearch.model.VPCDerivedInfoStatus] =
      Optional.Absent,
    cognitoOptions: Optional[zio.aws.opensearch.model.CognitoOptionsStatus] =
      Optional.Absent,
    encryptionAtRestOptions: Optional[
      zio.aws.opensearch.model.EncryptionAtRestOptionsStatus
    ] = Optional.Absent,
    nodeToNodeEncryptionOptions: Optional[
      zio.aws.opensearch.model.NodeToNodeEncryptionOptionsStatus
    ] = Optional.Absent,
    advancedOptions: Optional[zio.aws.opensearch.model.AdvancedOptionsStatus] =
      Optional.Absent,
    logPublishingOptions: Optional[
      zio.aws.opensearch.model.LogPublishingOptionsStatus
    ] = Optional.Absent,
    domainEndpointOptions: Optional[
      zio.aws.opensearch.model.DomainEndpointOptionsStatus
    ] = Optional.Absent,
    advancedSecurityOptions: Optional[
      zio.aws.opensearch.model.AdvancedSecurityOptionsStatus
    ] = Optional.Absent,
    autoTuneOptions: Optional[zio.aws.opensearch.model.AutoTuneOptionsStatus] =
      Optional.Absent,
    changeProgressDetails: Optional[
      zio.aws.opensearch.model.ChangeProgressDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DomainConfig = {
    import DomainConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DomainConfig
      .builder()
      .optionallyWith(engineVersion.map(value => value.buildAwsValue()))(
        _.engineVersion
      )
      .optionallyWith(clusterConfig.map(value => value.buildAwsValue()))(
        _.clusterConfig
      )
      .optionallyWith(ebsOptions.map(value => value.buildAwsValue()))(
        _.ebsOptions
      )
      .optionallyWith(accessPolicies.map(value => value.buildAwsValue()))(
        _.accessPolicies
      )
      .optionallyWith(snapshotOptions.map(value => value.buildAwsValue()))(
        _.snapshotOptions
      )
      .optionallyWith(vpcOptions.map(value => value.buildAwsValue()))(
        _.vpcOptions
      )
      .optionallyWith(cognitoOptions.map(value => value.buildAwsValue()))(
        _.cognitoOptions
      )
      .optionallyWith(
        encryptionAtRestOptions.map(value => value.buildAwsValue())
      )(_.encryptionAtRestOptions)
      .optionallyWith(
        nodeToNodeEncryptionOptions.map(value => value.buildAwsValue())
      )(_.nodeToNodeEncryptionOptions)
      .optionallyWith(advancedOptions.map(value => value.buildAwsValue()))(
        _.advancedOptions
      )
      .optionallyWith(logPublishingOptions.map(value => value.buildAwsValue()))(
        _.logPublishingOptions
      )
      .optionallyWith(
        domainEndpointOptions.map(value => value.buildAwsValue())
      )(_.domainEndpointOptions)
      .optionallyWith(
        advancedSecurityOptions.map(value => value.buildAwsValue())
      )(_.advancedSecurityOptions)
      .optionallyWith(autoTuneOptions.map(value => value.buildAwsValue()))(
        _.autoTuneOptions
      )
      .optionallyWith(
        changeProgressDetails.map(value => value.buildAwsValue())
      )(_.changeProgressDetails)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DomainConfig.ReadOnly =
    zio.aws.opensearch.model.DomainConfig.wrap(buildAwsValue())
}
object DomainConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DomainConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DomainConfig =
      zio.aws.opensearch.model.DomainConfig(
        engineVersion.map(value => value.asEditable),
        clusterConfig.map(value => value.asEditable),
        ebsOptions.map(value => value.asEditable),
        accessPolicies.map(value => value.asEditable),
        snapshotOptions.map(value => value.asEditable),
        vpcOptions.map(value => value.asEditable),
        cognitoOptions.map(value => value.asEditable),
        encryptionAtRestOptions.map(value => value.asEditable),
        nodeToNodeEncryptionOptions.map(value => value.asEditable),
        advancedOptions.map(value => value.asEditable),
        logPublishingOptions.map(value => value.asEditable),
        domainEndpointOptions.map(value => value.asEditable),
        advancedSecurityOptions.map(value => value.asEditable),
        autoTuneOptions.map(value => value.asEditable),
        changeProgressDetails.map(value => value.asEditable)
      )
    def engineVersion: Optional[zio.aws.opensearch.model.VersionStatus.ReadOnly]
    def clusterConfig
        : Optional[zio.aws.opensearch.model.ClusterConfigStatus.ReadOnly]
    def ebsOptions: Optional[zio.aws.opensearch.model.EBSOptionsStatus.ReadOnly]
    def accessPolicies
        : Optional[zio.aws.opensearch.model.AccessPoliciesStatus.ReadOnly]
    def snapshotOptions
        : Optional[zio.aws.opensearch.model.SnapshotOptionsStatus.ReadOnly]
    def vpcOptions
        : Optional[zio.aws.opensearch.model.VPCDerivedInfoStatus.ReadOnly]
    def cognitoOptions
        : Optional[zio.aws.opensearch.model.CognitoOptionsStatus.ReadOnly]
    def encryptionAtRestOptions: Optional[
      zio.aws.opensearch.model.EncryptionAtRestOptionsStatus.ReadOnly
    ]
    def nodeToNodeEncryptionOptions: Optional[
      zio.aws.opensearch.model.NodeToNodeEncryptionOptionsStatus.ReadOnly
    ]
    def advancedOptions
        : Optional[zio.aws.opensearch.model.AdvancedOptionsStatus.ReadOnly]
    def logPublishingOptions
        : Optional[zio.aws.opensearch.model.LogPublishingOptionsStatus.ReadOnly]
    def domainEndpointOptions: Optional[
      zio.aws.opensearch.model.DomainEndpointOptionsStatus.ReadOnly
    ]
    def advancedSecurityOptions: Optional[
      zio.aws.opensearch.model.AdvancedSecurityOptionsStatus.ReadOnly
    ]
    def autoTuneOptions
        : Optional[zio.aws.opensearch.model.AutoTuneOptionsStatus.ReadOnly]
    def changeProgressDetails
        : Optional[zio.aws.opensearch.model.ChangeProgressDetails.ReadOnly]
    def getEngineVersion
        : ZIO[Any, AwsError, zio.aws.opensearch.model.VersionStatus.ReadOnly] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getClusterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.ClusterConfigStatus.ReadOnly
    ] = AwsError.unwrapOptionField("clusterConfig", clusterConfig)
    def getEbsOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.EBSOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("ebsOptions", ebsOptions)
    def getAccessPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.AccessPoliciesStatus.ReadOnly
    ] = AwsError.unwrapOptionField("accessPolicies", accessPolicies)
    def getSnapshotOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.SnapshotOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("snapshotOptions", snapshotOptions)
    def getVpcOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.VPCDerivedInfoStatus.ReadOnly
    ] = AwsError.unwrapOptionField("vpcOptions", vpcOptions)
    def getCognitoOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.CognitoOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("cognitoOptions", cognitoOptions)
    def getEncryptionAtRestOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.EncryptionAtRestOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionAtRestOptions",
      encryptionAtRestOptions
    )
    def getNodeToNodeEncryptionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.NodeToNodeEncryptionOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nodeToNodeEncryptionOptions",
      nodeToNodeEncryptionOptions
    )
    def getAdvancedOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.AdvancedOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("advancedOptions", advancedOptions)
    def getLogPublishingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.LogPublishingOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("logPublishingOptions", logPublishingOptions)
    def getDomainEndpointOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.DomainEndpointOptionsStatus.ReadOnly
    ] =
      AwsError.unwrapOptionField("domainEndpointOptions", domainEndpointOptions)
    def getAdvancedSecurityOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.AdvancedSecurityOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "advancedSecurityOptions",
      advancedSecurityOptions
    )
    def getAutoTuneOptions: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.AutoTuneOptionsStatus.ReadOnly
    ] = AwsError.unwrapOptionField("autoTuneOptions", autoTuneOptions)
    def getChangeProgressDetails: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.ChangeProgressDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("changeProgressDetails", changeProgressDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DomainConfig
  ) extends zio.aws.opensearch.model.DomainConfig.ReadOnly {
    override val engineVersion
        : Optional[zio.aws.opensearch.model.VersionStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineVersion())
        .map(value => zio.aws.opensearch.model.VersionStatus.wrap(value))
    override val clusterConfig
        : Optional[zio.aws.opensearch.model.ClusterConfigStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterConfig())
        .map(value => zio.aws.opensearch.model.ClusterConfigStatus.wrap(value))
    override val ebsOptions
        : Optional[zio.aws.opensearch.model.EBSOptionsStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsOptions())
        .map(value => zio.aws.opensearch.model.EBSOptionsStatus.wrap(value))
    override val accessPolicies
        : Optional[zio.aws.opensearch.model.AccessPoliciesStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessPolicies())
        .map(value => zio.aws.opensearch.model.AccessPoliciesStatus.wrap(value))
    override val snapshotOptions
        : Optional[zio.aws.opensearch.model.SnapshotOptionsStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotOptions())
        .map(value =>
          zio.aws.opensearch.model.SnapshotOptionsStatus.wrap(value)
        )
    override val vpcOptions
        : Optional[zio.aws.opensearch.model.VPCDerivedInfoStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcOptions())
        .map(value => zio.aws.opensearch.model.VPCDerivedInfoStatus.wrap(value))
    override val cognitoOptions
        : Optional[zio.aws.opensearch.model.CognitoOptionsStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cognitoOptions())
        .map(value => zio.aws.opensearch.model.CognitoOptionsStatus.wrap(value))
    override val encryptionAtRestOptions: Optional[
      zio.aws.opensearch.model.EncryptionAtRestOptionsStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionAtRestOptions())
      .map(value =>
        zio.aws.opensearch.model.EncryptionAtRestOptionsStatus.wrap(value)
      )
    override val nodeToNodeEncryptionOptions: Optional[
      zio.aws.opensearch.model.NodeToNodeEncryptionOptionsStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeToNodeEncryptionOptions())
      .map(value =>
        zio.aws.opensearch.model.NodeToNodeEncryptionOptionsStatus.wrap(value)
      )
    override val advancedOptions
        : Optional[zio.aws.opensearch.model.AdvancedOptionsStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.advancedOptions())
        .map(value =>
          zio.aws.opensearch.model.AdvancedOptionsStatus.wrap(value)
        )
    override val logPublishingOptions: Optional[
      zio.aws.opensearch.model.LogPublishingOptionsStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.logPublishingOptions())
      .map(value =>
        zio.aws.opensearch.model.LogPublishingOptionsStatus.wrap(value)
      )
    override val domainEndpointOptions: Optional[
      zio.aws.opensearch.model.DomainEndpointOptionsStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainEndpointOptions())
      .map(value =>
        zio.aws.opensearch.model.DomainEndpointOptionsStatus.wrap(value)
      )
    override val advancedSecurityOptions: Optional[
      zio.aws.opensearch.model.AdvancedSecurityOptionsStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.advancedSecurityOptions())
      .map(value =>
        zio.aws.opensearch.model.AdvancedSecurityOptionsStatus.wrap(value)
      )
    override val autoTuneOptions
        : Optional[zio.aws.opensearch.model.AutoTuneOptionsStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoTuneOptions())
        .map(value =>
          zio.aws.opensearch.model.AutoTuneOptionsStatus.wrap(value)
        )
    override val changeProgressDetails
        : Optional[zio.aws.opensearch.model.ChangeProgressDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeProgressDetails())
        .map(value =>
          zio.aws.opensearch.model.ChangeProgressDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DomainConfig
  ): zio.aws.opensearch.model.DomainConfig.ReadOnly = new Wrapper(impl)
}
