package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DomainInformationContainer(
    awsDomainInformation: Optional[
      zio.aws.opensearch.model.AWSDomainInformation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DomainInformationContainer = {
    import DomainInformationContainer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DomainInformationContainer
      .builder()
      .optionallyWith(awsDomainInformation.map(value => value.buildAwsValue()))(
        _.awsDomainInformation
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DomainInformationContainer.ReadOnly =
    zio.aws.opensearch.model.DomainInformationContainer.wrap(buildAwsValue())
}
object DomainInformationContainer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DomainInformationContainer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DomainInformationContainer =
      zio.aws.opensearch.model.DomainInformationContainer(
        awsDomainInformation.map(value => value.asEditable)
      )
    def awsDomainInformation
        : Optional[zio.aws.opensearch.model.AWSDomainInformation.ReadOnly]
    def getAwsDomainInformation: ZIO[
      Any,
      AwsError,
      zio.aws.opensearch.model.AWSDomainInformation.ReadOnly
    ] = AwsError.unwrapOptionField("awsDomainInformation", awsDomainInformation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DomainInformationContainer
  ) extends zio.aws.opensearch.model.DomainInformationContainer.ReadOnly {
    override val awsDomainInformation
        : Optional[zio.aws.opensearch.model.AWSDomainInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsDomainInformation())
        .map(value => zio.aws.opensearch.model.AWSDomainInformation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DomainInformationContainer
  ): zio.aws.opensearch.model.DomainInformationContainer.ReadOnly = new Wrapper(
    impl
  )
}
