package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.{Message, DeploymentType}
import scala.jdk.CollectionConverters.*
final case class DryRunResults(
    deploymentType: Optional[DeploymentType] = Optional.Absent,
    message: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.DryRunResults = {
    import DryRunResults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.DryRunResults
      .builder()
      .optionallyWith(
        deploymentType.map(value =>
          DeploymentType.unwrap(value): java.lang.String
        )
      )(_.deploymentType)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.DryRunResults.ReadOnly =
    zio.aws.opensearch.model.DryRunResults.wrap(buildAwsValue())
}
object DryRunResults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.DryRunResults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.DryRunResults =
      zio.aws.opensearch.model.DryRunResults(
        deploymentType.map(value => value),
        message.map(value => value)
      )
    def deploymentType: Optional[DeploymentType]
    def message: Optional[Message]
    def getDeploymentType: ZIO[Any, AwsError, DeploymentType] =
      AwsError.unwrapOptionField("deploymentType", deploymentType)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.DryRunResults
  ) extends zio.aws.opensearch.model.DryRunResults.ReadOnly {
    override val deploymentType: Optional[DeploymentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentType())
        .map(value => zio.aws.opensearch.model.primitives.DeploymentType(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.opensearch.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.DryRunResults
  ): zio.aws.opensearch.model.DryRunResults.ReadOnly = new Wrapper(impl)
}
