package zio.aws.opensearch.model
import zio.aws.opensearch.model.primitives.IntegerClass
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class EBSOptions(
    ebsEnabled: Optional[Boolean] = Optional.Absent,
    volumeType: Optional[zio.aws.opensearch.model.VolumeType] = Optional.Absent,
    volumeSize: Optional[IntegerClass] = Optional.Absent,
    iops: Optional[IntegerClass] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.EBSOptions = {
    import EBSOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.EBSOptions
      .builder()
      .optionallyWith(ebsEnabled.map(value => value: java.lang.Boolean))(
        _.ebsEnabled
      )
      .optionallyWith(volumeType.map(value => value.unwrap))(_.volumeType)
      .optionallyWith(
        volumeSize.map(value => IntegerClass.unwrap(value): Integer)
      )(_.volumeSize)
      .optionallyWith(iops.map(value => IntegerClass.unwrap(value): Integer))(
        _.iops
      )
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.EBSOptions.ReadOnly =
    zio.aws.opensearch.model.EBSOptions.wrap(buildAwsValue())
}
object EBSOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.EBSOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.EBSOptions =
      zio.aws.opensearch.model.EBSOptions(
        ebsEnabled.map(value => value),
        volumeType.map(value => value),
        volumeSize.map(value => value),
        iops.map(value => value)
      )
    def ebsEnabled: Optional[Boolean]
    def volumeType: Optional[zio.aws.opensearch.model.VolumeType]
    def volumeSize: Optional[IntegerClass]
    def iops: Optional[IntegerClass]
    def getEbsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsEnabled", ebsEnabled)
    def getVolumeType: ZIO[Any, AwsError, zio.aws.opensearch.model.VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getVolumeSize: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getIops: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("iops", iops)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.EBSOptions
  ) extends zio.aws.opensearch.model.EBSOptions.ReadOnly {
    override val ebsEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsEnabled())
      .map(value => value: Boolean)
    override val volumeType: Optional[zio.aws.opensearch.model.VolumeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeType())
        .map(value => zio.aws.opensearch.model.VolumeType.wrap(value))
    override val volumeSize: Optional[IntegerClass] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSize())
      .map(value => zio.aws.opensearch.model.primitives.IntegerClass(value))
    override val iops: Optional[IntegerClass] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => zio.aws.opensearch.model.primitives.IntegerClass(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.EBSOptions
  ): zio.aws.opensearch.model.EBSOptions.ReadOnly = new Wrapper(impl)
}
