package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EBSOptionsStatus(
    options: zio.aws.opensearch.model.EBSOptions,
    status: zio.aws.opensearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.EBSOptionsStatus = {
    import EBSOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.EBSOptionsStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.EBSOptionsStatus.ReadOnly =
    zio.aws.opensearch.model.EBSOptionsStatus.wrap(buildAwsValue())
}
object EBSOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.EBSOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.EBSOptionsStatus =
      zio.aws.opensearch.model
        .EBSOptionsStatus(options.asEditable, status.asEditable)
    def options: zio.aws.opensearch.model.EBSOptions.ReadOnly
    def status: zio.aws.opensearch.model.OptionStatus.ReadOnly
    def getOptions
        : ZIO[Any, Nothing, zio.aws.opensearch.model.EBSOptions.ReadOnly] =
      ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.opensearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.EBSOptionsStatus
  ) extends zio.aws.opensearch.model.EBSOptionsStatus.ReadOnly {
    override val options: zio.aws.opensearch.model.EBSOptions.ReadOnly =
      zio.aws.opensearch.model.EBSOptions.wrap(impl.options())
    override val status: zio.aws.opensearch.model.OptionStatus.ReadOnly =
      zio.aws.opensearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.EBSOptionsStatus
  ): zio.aws.opensearch.model.EBSOptionsStatus.ReadOnly = new Wrapper(impl)
}
