package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.KmsKeyId
import scala.jdk.CollectionConverters.*
final case class EncryptionAtRestOptions(
    enabled: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.EncryptionAtRestOptions = {
    import EncryptionAtRestOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.EncryptionAtRestOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.EncryptionAtRestOptions.ReadOnly =
    zio.aws.opensearch.model.EncryptionAtRestOptions.wrap(buildAwsValue())
}
object EncryptionAtRestOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.EncryptionAtRestOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.EncryptionAtRestOptions =
      zio.aws.opensearch.model.EncryptionAtRestOptions(
        enabled.map(value => value),
        kmsKeyId.map(value => value)
      )
    def enabled: Optional[Boolean]
    def kmsKeyId: Optional[KmsKeyId]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.EncryptionAtRestOptions
  ) extends zio.aws.opensearch.model.EncryptionAtRestOptions.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.opensearch.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.EncryptionAtRestOptions
  ): zio.aws.opensearch.model.EncryptionAtRestOptions.ReadOnly = new Wrapper(
    impl
  )
}
