package zio.aws.opensearch.model
import scala.jdk.CollectionConverters.*
sealed trait EngineType {
  def unwrap: software.amazon.awssdk.services.opensearch.model.EngineType
}
object EngineType {
  def wrap(
      value: software.amazon.awssdk.services.opensearch.model.EngineType
  ): zio.aws.opensearch.model.EngineType = value match {
    case software.amazon.awssdk.services.opensearch.model.EngineType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.opensearch.model.EngineType.OPEN_SEARCH =>
      val r = OpenSearch
      r
    case software.amazon.awssdk.services.opensearch.model.EngineType.ELASTICSEARCH =>
      val r = Elasticsearch
      r
  }
  case object unknownToSdkVersion extends zio.aws.opensearch.model.EngineType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.EngineType =
      software.amazon.awssdk.services.opensearch.model.EngineType.UNKNOWN_TO_SDK_VERSION
  }
  case object OpenSearch extends zio.aws.opensearch.model.EngineType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.EngineType =
      software.amazon.awssdk.services.opensearch.model.EngineType.OPEN_SEARCH
  }
  case object Elasticsearch extends zio.aws.opensearch.model.EngineType {
    override def unwrap
        : software.amazon.awssdk.services.opensearch.model.EngineType =
      software.amazon.awssdk.services.opensearch.model.EngineType.ELASTICSEARCH
  }
}
