package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCompatibleVersionsResponse(
    compatibleVersions: Optional[
      Iterable[zio.aws.opensearch.model.CompatibleVersionsMap]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsResponse = {
    import GetCompatibleVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsResponse
      .builder()
      .optionallyWith(
        compatibleVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.compatibleVersions)
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.GetCompatibleVersionsResponse.ReadOnly =
    zio.aws.opensearch.model.GetCompatibleVersionsResponse.wrap(buildAwsValue())
}
object GetCompatibleVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.GetCompatibleVersionsResponse =
      zio.aws.opensearch.model.GetCompatibleVersionsResponse(
        compatibleVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def compatibleVersions: Optional[
      List[zio.aws.opensearch.model.CompatibleVersionsMap.ReadOnly]
    ]
    def getCompatibleVersions: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.CompatibleVersionsMap.ReadOnly
    ]] = AwsError.unwrapOptionField("compatibleVersions", compatibleVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsResponse
  ) extends zio.aws.opensearch.model.GetCompatibleVersionsResponse.ReadOnly {
    override val compatibleVersions: Optional[
      List[zio.aws.opensearch.model.CompatibleVersionsMap.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.compatibleVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearch.model.CompatibleVersionsMap.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.GetCompatibleVersionsResponse
  ): zio.aws.opensearch.model.GetCompatibleVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
