package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.PackageID
import scala.jdk.CollectionConverters.*
final case class GetPackageVersionHistoryResponse(
    packageID: Optional[PackageID] = Optional.Absent,
    packageVersionHistoryList: Optional[
      Iterable[zio.aws.opensearch.model.PackageVersionHistory]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse = {
    import GetPackageVersionHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse
      .builder()
      .optionallyWith(
        packageID.map(value => PackageID.unwrap(value): java.lang.String)
      )(_.packageID)
      .optionallyWith(
        packageVersionHistoryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.packageVersionHistoryList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.opensearch.model.GetPackageVersionHistoryResponse.ReadOnly =
    zio.aws.opensearch.model.GetPackageVersionHistoryResponse
      .wrap(buildAwsValue())
}
object GetPackageVersionHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.GetPackageVersionHistoryResponse =
      zio.aws.opensearch.model.GetPackageVersionHistoryResponse(
        packageID.map(value => value),
        packageVersionHistoryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def packageID: Optional[PackageID]
    def packageVersionHistoryList: Optional[
      List[zio.aws.opensearch.model.PackageVersionHistory.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getPackageID: ZIO[Any, AwsError, PackageID] =
      AwsError.unwrapOptionField("packageID", packageID)
    def getPackageVersionHistoryList: ZIO[Any, AwsError, List[
      zio.aws.opensearch.model.PackageVersionHistory.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "packageVersionHistoryList",
      packageVersionHistoryList
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse
  ) extends zio.aws.opensearch.model.GetPackageVersionHistoryResponse.ReadOnly {
    override val packageID: Optional[PackageID] = zio.aws.core.internal
      .optionalFromNullable(impl.packageID())
      .map(value => zio.aws.opensearch.model.primitives.PackageID(value))
    override val packageVersionHistoryList: Optional[
      List[zio.aws.opensearch.model.PackageVersionHistory.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.packageVersionHistoryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.opensearch.model.PackageVersionHistory.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.GetPackageVersionHistoryResponse
  ): zio.aws.opensearch.model.GetPackageVersionHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
