package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.opensearch.model.primitives.DomainName
import scala.jdk.CollectionConverters.*
final case class GetUpgradeStatusRequest(domainName: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusRequest = {
    import GetUpgradeStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.GetUpgradeStatusRequest.ReadOnly =
    zio.aws.opensearch.model.GetUpgradeStatusRequest.wrap(buildAwsValue())
}
object GetUpgradeStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.GetUpgradeStatusRequest =
      zio.aws.opensearch.model.GetUpgradeStatusRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusRequest
  ) extends zio.aws.opensearch.model.GetUpgradeStatusRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.opensearch.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusRequest
  ): zio.aws.opensearch.model.GetUpgradeStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
