package zio.aws.opensearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.opensearch.model.primitives.UpgradeName
import scala.jdk.CollectionConverters.*
final case class GetUpgradeStatusResponse(
    upgradeStep: Optional[zio.aws.opensearch.model.UpgradeStep] =
      Optional.Absent,
    stepStatus: Optional[zio.aws.opensearch.model.UpgradeStatus] =
      Optional.Absent,
    upgradeName: Optional[UpgradeName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusResponse = {
    import GetUpgradeStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusResponse
      .builder()
      .optionallyWith(upgradeStep.map(value => value.unwrap))(_.upgradeStep)
      .optionallyWith(stepStatus.map(value => value.unwrap))(_.stepStatus)
      .optionallyWith(
        upgradeName.map(value => UpgradeName.unwrap(value): java.lang.String)
      )(_.upgradeName)
      .build()
  }
  def asReadOnly: zio.aws.opensearch.model.GetUpgradeStatusResponse.ReadOnly =
    zio.aws.opensearch.model.GetUpgradeStatusResponse.wrap(buildAwsValue())
}
object GetUpgradeStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.opensearch.model.GetUpgradeStatusResponse =
      zio.aws.opensearch.model.GetUpgradeStatusResponse(
        upgradeStep.map(value => value),
        stepStatus.map(value => value),
        upgradeName.map(value => value)
      )
    def upgradeStep: Optional[zio.aws.opensearch.model.UpgradeStep]
    def stepStatus: Optional[zio.aws.opensearch.model.UpgradeStatus]
    def upgradeName: Optional[UpgradeName]
    def getUpgradeStep
        : ZIO[Any, AwsError, zio.aws.opensearch.model.UpgradeStep] =
      AwsError.unwrapOptionField("upgradeStep", upgradeStep)
    def getStepStatus
        : ZIO[Any, AwsError, zio.aws.opensearch.model.UpgradeStatus] =
      AwsError.unwrapOptionField("stepStatus", stepStatus)
    def getUpgradeName: ZIO[Any, AwsError, UpgradeName] =
      AwsError.unwrapOptionField("upgradeName", upgradeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusResponse
  ) extends zio.aws.opensearch.model.GetUpgradeStatusResponse.ReadOnly {
    override val upgradeStep: Optional[zio.aws.opensearch.model.UpgradeStep] =
      zio.aws.core.internal
        .optionalFromNullable(impl.upgradeStep())
        .map(value => zio.aws.opensearch.model.UpgradeStep.wrap(value))
    override val stepStatus: Optional[zio.aws.opensearch.model.UpgradeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepStatus())
        .map(value => zio.aws.opensearch.model.UpgradeStatus.wrap(value))
    override val upgradeName: Optional[UpgradeName] = zio.aws.core.internal
      .optionalFromNullable(impl.upgradeName())
      .map(value => zio.aws.opensearch.model.primitives.UpgradeName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.opensearch.model.GetUpgradeStatusResponse
  ): zio.aws.opensearch.model.GetUpgradeStatusResponse.ReadOnly = new Wrapper(
    impl
  )
}
